/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.item;

import fuzs.puzzleslib.api.item.v2.GiveItemHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import fuzs.sealife.init.ModRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class TreasureItem
extends Item {
    private final ResourceKey<LootTable> lootTable;

    public TreasureItem(Item.Properties properties, ResourceKey<LootTable> lootTable) {
        super(properties);
        this.lootTable = lootTable;
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        ItemStack originalItemInHand = itemInHand.copy();
        itemInHand.consume(1, (LivingEntity)player);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(this.lootTable);
            ObjectArrayList items = lootTable.getRandomItems(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.TOOL, (Object)originalItemInHand).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).create(ModRegistry.TREASURE_ITEM_LOOT_CONTEXT_PARAM_SET));
            for (ItemStack itemStack : items) {
                GiveItemHelper.giveItem((ItemStack)itemStack, (ServerPlayer)((ServerPlayer)player));
            }
        }
        return InteractionResultHelper.sidedSuccess((ItemStack)itemInHand, (boolean)level.isClientSide());
    }
}

