/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block.entity;

import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import fuzs.sealife.init.ModBlocks;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.FishTrapBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class FishTrapBlockEntity
extends BlockEntity
implements ListBackedContainer,
TickingBlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private float currentSpin;
    private float previousSpin;

    public FishTrapBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.FISH_TRAP_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
    }

    public void clientTick() {
        this.previousSpin = this.currentSpin;
        this.currentSpin = Mth.wrapDegrees((float)(this.currentSpin + 5.0f));
        RandomSource randomSource = this.getLevel().getRandom();
        if (randomSource.nextFloat() <= 0.5f) {
            Vec3 vec3 = FishTrapBlockEntity.randomPosInsideCage(this.getBlockPos(), randomSource);
            if (((Boolean)this.getBlockState().getValue((Property)FishTrapBlock.ENABLED)).booleanValue() && this.isBaited()) {
                this.getLevel().addParticle((ParticleOptions)ModRegistry.BUBBLE_PARTICLE_TYPE.value(), vec3.x(), vec3.y(), vec3.z(), 0.0, 0.0, 0.0);
            }
        }
    }

    private static Vec3 randomPosInsideCage(BlockPos pos, RandomSource random) {
        return Vec3.atLowerCornerOf((Vec3i)pos).add(Mth.nextDouble((RandomSource)random, (double)0.1, (double)0.9), Mth.nextDouble((RandomSource)random, (double)0.25, (double)1.25), Mth.nextDouble((RandomSource)random, (double)0.1, (double)0.9));
    }

    public float getSpin(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.previousSpin, (float)this.currentSpin);
    }

    public boolean isBaited() {
        return this.getItem(0).is(ModRegistry.FISHING_BAIT_ITEM_TAG);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerSerializationHelper.loadAllItems((ValueInput)valueInput, this.items);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items, (boolean)true);
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.items;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)pos, this.getContainerItems());
        }
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        ((ItemContainerContents)componentGetter.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getContainerItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getContainerItems()));
    }

    public void removeComponentsFromTag(ValueOutput valueOutput) {
        valueOutput.discard("Items");
    }
}

