package eva.dualwielding.mixin;

import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.util.OffhandAttack;
import eva.dualwielding.util.OffhandMine;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value = class_1657.class, priority = 1001)
public abstract class PlayerEntityMixin extends class_1309 implements PlayerAccess {

    @Unique
    private int lastAttackedOffhandTicks;
    @Unique
    private final class_1657 pe = (class_1657) (Object) this;

    public PlayerEntityMixin(class_1937 world) {
        super(class_1299.field_6097, world);
    }

    @Inject(method = "tick()V", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/player/PlayerEntity;lastAttackedTicks:I", ordinal = 0))
    private void tickMixin(CallbackInfo info) {
        lastAttackedOffhandTicks++;
    }

    @Unique
    public float dualWielding$getAttackCooldownProgressPerTick() {
        return OffhandAttack.getOffhandAttackCooldownProgressPerTick(pe);
    }

    @Unique
    public void dualWielding$attackOffhand(class_1297 target) {
        OffhandAttack.offhandAttack(pe, target);
    }

    @Unique
    public void dualWielding$resetLastAttackTicks() {
        this.lastAttackedOffhandTicks = 0;
    }

    @Unique
    public float dualWielding$getAttackCooldownProgress(float baseTime) {
        return class_3532.method_15363(((float) this.lastAttackedOffhandTicks + baseTime) / this.dualWielding$getAttackCooldownProgressPerTick(), 0.0F, 1.0F);
    }

    @Unique
    public float dualWielding$getBlockBreakingSpeed(class_2680 block) {
        return OffhandMine.getBlockBreakingSpeed(block, pe);
    }

    @Unique
    public boolean dualWielding$isBlockBreakingRestricted(class_1937 world, class_2338 pos, class_1934 gameMode) {
        return OffhandMine.isOffhandBlockBreakingRestricted(world, pos, gameMode, pe);
    }

    @Unique
    public boolean dualWielding$canHarvest(class_2680 state) {
        return !state.method_29291() || pe.method_6079().method_7951(state);
    }

    @Unique
    private boolean isOffHand = false;

    @Inject(method = "getEquippedStack", at = @At("HEAD"), cancellable = true)
    private void mainHandStackChanger(class_1304 slot, CallbackInfoReturnable<class_1799> cir) {
        if (slot.equals(class_1304.field_6173) && isOffHand) {
            cir.setReturnValue(this.method_6079());
            cir.cancel();
        }
    }

    @Override
    public class_1657 dualWielding$setMainHandStack(boolean isOffHand) {
        this.isOffHand = isOffHand;
        return (class_1657) (Object) this;
    }

}
