package eva.dualwielding.mixin;

import eva.dualwielding.DualWieldingMain;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.access.ServerManagerAccess;
import eva.dualwielding.network.MinePayload;
import eva.dualwielding.util.OffhandMine;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_5552;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_3225.class)
public class ServerPlayerInteractionManagerMixin implements ServerManagerAccess {
    
    @Final @Shadow protected class_3222 player;
    @Shadow protected class_3218 world;
    @Shadow private class_1934 gameMode;
    @Shadow private int failedStartMiningTime;
    @Shadow private int startMiningTime;
    @Shadow private boolean failedToMine;
    @Shadow private class_2338 failedMiningPos;
    @Shadow private class_2338 miningPos;
    @Shadow private int blockBreakingProgress;
    @Shadow private boolean mining;

    @Shadow private int tickCounter;
    @Unique private int useTickCounter() {
        return tickCounter + 1;
    }

    @Inject(method = "update", at = @At(value = "HEAD"))
    public void doUpdate(CallbackInfo ci) {
        ((PlayerAccess) player).dualWielding$setMainHandStack(true);
        if (failedToMine) {
            class_2680 blockState = world.method_8320(failedMiningPos);
            if (blockState.method_26215()) {
                failedToMine = false;
            } else {
                float f = dualWielding$continueMining(blockState, failedMiningPos, failedStartMiningTime);
                if (f >= 1.0F) {
                    failedToMine = false;
                    dualWielding$tryBreakBlock(failedMiningPos);
                }
            }
        } else if (mining) {
            class_2680 blockState = world.method_8320(miningPos);
            if (blockState.method_26215()) {
                world.method_8517(player.method_5628(), miningPos, -1);
                blockBreakingProgress = -1;
                mining = false;
            } else {
                dualWielding$continueMining(blockState, miningPos, startMiningTime);
            }
        }
        ((PlayerAccess) player).dualWielding$setMainHandStack(false);
    }

    @Unique
    public void dualWielding$processBlockBreakingAction(class_2338 pos, MinePayload.Action action, class_2350 direction, int worldHeight, int sequence) {
        if (!player.method_56093(pos, 1.0)) {
            dualWielding$onBlockBreakingAction(pos, false, sequence, "too far");
        } else if (pos.method_10264() > worldHeight) {
            player.field_13987.method_14364(new class_2626(pos, world.method_8320(pos)));
            dualWielding$onBlockBreakingAction(pos, false, sequence, "too high");
        } else {
            if (action == MinePayload.Action.START_DESTROY_BLOCK) {
                if (!world.method_8505(player, pos)) {
                    player.field_13987.method_14364(new class_2626(pos, world.method_8320(pos)));
                    dualWielding$onBlockBreakingAction(pos, false, sequence, "may not interact");
                    return;
                }

                if (!((PlayerAccess)player).dualWielding$isBlockBreakingRestricted(world, pos, gameMode)) {
                    player.field_13987.method_14364(new class_2626(pos, world.method_8320(pos)));
                    dualWielding$onBlockBreakingAction(pos, false, sequence, "block action restricted");
                    return;
                }

                startMiningTime = useTickCounter();
                float f = 1.0F;
                class_2680 blockState = world.method_8320(pos);
                if (!blockState.method_26215()) {
                    class_1890.method_60124(
                            world,
                            player.method_6079(),
                            player,
                            player,
                            class_1304.field_6173,
                            class_243.method_24953(pos),
                            blockState,
                            item -> player.method_20235(item, class_1304.field_6171)
                    );
                    blockState.method_26179(world, pos, player);
                    f = OffhandMine.calcBlockBreakingDelta(blockState, player, player.method_37908(), pos);
//                    f = ((BlockAccess)blockState).dualWielding$calcBlockBreakingDelta(player, player.getWorld(), pos);
                }

                if (!blockState.method_26215() && f >= 1.0F) {
                    dualWielding$finishMining(pos, sequence, "insta mine");
                } else {
                    if (mining) {
                        player.field_13987.method_14364(new class_2626(miningPos, world.method_8320(miningPos)));
                        dualWielding$onBlockBreakingAction(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                    }

                    mining = true;
                    miningPos = pos.method_10062();
                    int i = (int)(f * 10.0F);
                    world.method_8517(player.method_5628(), pos, i);
                    dualWielding$onBlockBreakingAction(pos, true, sequence, "actual start of destroying");
                    blockBreakingProgress = i;
                }
            } else if (action == MinePayload.Action.STOP_DESTROY_BLOCK) {
                if (pos.equals(miningPos)) {
                    int j = useTickCounter() - startMiningTime;
                    class_2680 blockStatex = world.method_8320(pos);
                    if (!blockStatex.method_26215()) {
                        float g = OffhandMine.calcBlockBreakingDelta(blockStatex, player, player.method_37908(), pos) * (j + 1);
//                        float g = ((BlockAccess)blockStatex).dualWielding$calcBlockBreakingDelta(player, player.getWorld(), pos) * (j + 1);
                        if (g >= 0.7F) {
                            mining = false;
                            world.method_8517(player.method_5628(), pos, -1);
                            dualWielding$finishMining(pos, sequence, "destroyed");
                            return;
                        }

                        if (!failedToMine) {
                            mining = false;
                            failedToMine = true;
                            failedMiningPos = pos;
                            failedStartMiningTime = startMiningTime;
                        }
                    }
                }

                dualWielding$onBlockBreakingAction(pos, true, sequence, "stopped destroying");
            } else if (action == MinePayload.Action.ABORT_DESTROY_BLOCK) {
                mining = false;
                if (!Objects.equals(miningPos, pos)) {
                    DualWieldingMain.LOGGER.warn("Mismatch in destroy block pos: {} {}", miningPos, pos);
                    world.method_8517(player.method_5628(), miningPos, -1);
                    dualWielding$onBlockBreakingAction(pos, true, sequence, "aborted mismatched destroying");
                }

                world.method_8517(player.method_5628(), pos, -1);
                dualWielding$onBlockBreakingAction(pos, true, sequence, "aborted destroying");
            }
        }
    }

    @Unique
    public float dualWielding$continueMining(class_2680 state, class_2338 pos, int failedStartMiningTime) {
        int i = useTickCounter() - failedStartMiningTime;
//        float f = ((BlockAccess)state).dualWielding$calcBlockBreakingDelta(player, player.getWorld(), pos) * (i + 1);
        float f = OffhandMine.calcBlockBreakingDelta(state, player, player.method_37908(), pos) * (i + 1);
        int j = (int)(f * 10.0F);
        if (j != blockBreakingProgress) {
            world.method_8517(player.method_5628(), pos, j);
            blockBreakingProgress = j;
        }
        return f;
    }

    @Unique
    public void dualWielding$finishMining(class_2338 pos, int sequence, String reason) {
        if (dualWielding$tryBreakBlock(pos)) {
            dualWielding$onBlockBreakingAction(pos, true, sequence, reason);
        } else {
            player.field_13987.method_14364(new class_2626(pos, world.method_8320(pos)));
            dualWielding$onBlockBreakingAction(pos, false, sequence, reason);
        }

    }

    @Unique
    public boolean dualWielding$tryBreakBlock(class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!player.method_6079().method_7909().method_7885(blockState, world, pos, player)) {
            return false;
        } else {
            class_2586 blockEntity = world.method_8321(pos);
            class_2248 block = blockState.method_26204();
            if (block instanceof class_5552 && !player.method_7338()) {
                world.method_8413(pos, blockState, blockState, 3);
                return false;
            } else if (player.method_21701(world, pos, gameMode)) {
                return false;
            } else {
                class_2680 blockState2 = block.method_9576(world, pos, blockState, player);
                if (!PlayerBlockBreakEvents.BEFORE.invoker().beforeBlockBreak(world, player, pos, blockState2,blockEntity))
                    return false;
                boolean bl = world.method_8650(pos, false);
                if (bl) {
                    block.method_9585(world, pos, blockState2);
                }

                if (!((class_3225) (Object) this).method_14268()) {
                    class_1799 itemStack = player.method_6079();
                    class_1799 itemStack2 = itemStack.method_7972();
                    boolean bl2 = ((PlayerAccess)player).dualWielding$canHarvest(blockState2);
                    itemStack.method_7952(world, blockState2, pos, player);
                    if (bl && bl2) {
                        block.method_9556(world, player, pos, blockState2, blockEntity, itemStack2);
                    }
                }
                return true;
            }
        }
    }

    @Shadow(prefix = "dualWielding$")
    private void dualWielding$onBlockBreakingAction(class_2338 pos, boolean success, int sequence, String reason) {}
}
