package eva.dualwielding.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.init.ParticleInit;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

import static eva.dualwielding.config.ConfigInterpreter.*;

@Mixin(class_1657.class)
public class PlayerMixin implements PlayerAccess {
    @Unique
    private int lastAttackedOffhandTicks;
    @Unique
    private final class_1657 pe = (class_1657) (Object) this;
    @Unique
    private class_1799 lastItemInOffhand = class_1799.field_8037;
    @Final @Shadow class_1661 inventory;

    @Inject(method = "tick()V", at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/player/Player;attackStrengthTicker:I", ordinal = 0))
    private void tickMixin(CallbackInfo info) {
        lastAttackedOffhandTicks++;
    }

    @Unique
    public float dualWielding$getOffhandItemAttackStrengthDelay() {
        float a = modifyASpd((float) ((double) 1.0F / ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23723) * (double) 20.0F), pe, class_1268.field_5810);
        return a;
    }

    @Unique
    public void dualWielding$resetAttackStrengthTicker() {
        this.lastAttackedOffhandTicks = 0;
    }

    @Unique
    public float dualWielding$getAttackStrengthScale(float baseTime) {
        return class_3532.method_15363(((float) this.lastAttackedOffhandTicks + baseTime) / this.dualWielding$getOffhandItemAttackStrengthDelay(), 0.0F, 1.0F);
    }

    @Unique
    public boolean dualWielding$blockActionRestricted(class_1937 level, class_2338 pos, class_1934 gameMode) {
        return pe.method_7337() || pe.method_21701(level, pos, gameMode);
    }

    @Unique
    public boolean dualWielding$hasCorrectToolForDrops(class_2680 state) {
        return !state.method_29291() || pe.method_6079().method_7951(state);
    }

    @Unique
    public void dualWielding$attackOffhand(class_1297 target) {
        if (checkRA(pe, target)) return;
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(true);
        pe.method_7324(target);
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(false);
    }

    @Inject(
            method = "attack",
            at = @At("HEAD")
    )
    private void noInvulnerabilityForYou(class_1297 target, CallbackInfo ci) {
        if (target.field_6008 >= 17) {
            if ((((LivingEntityAccess) pe).isOffhand() ? this.dualWielding$getAttackStrengthScale(0.5F) : pe.method_7261(0.5F)) >= 0.95F)
                target.field_6008 = 0;
        }
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 0
            )
    )
    private double attackAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand())
            return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_23721);
        return original;
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F"
            )
    )
    private float strengthScaleGET(float original) {
        if (((LivingEntityAccess) pe).isOffhand()) return dualWielding$getAttackStrengthScale(0.5F);
        return original;
    }

    @Redirect(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V"
            )
    )
    private void attackStrengthResetter(class_1657 pe) {
        if (((LivingEntityAccess) pe).isOffhand()) ((PlayerAccess) pe).dualWielding$resetAttackStrengthTicker();
        else pe.method_7350();
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 mainHandChanger(class_1799 original) {
        return pe.method_59958();
    }

    @ModifyExpressionValue(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D",
                    ordinal = 1
            )
    )
    private double sweepingDamageRatioAttributeGET(double original) {
        if (((LivingEntityAccess) pe).isOffhand())
            return ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51577);
        return original;
    }

    @ModifyExpressionValue(
            method = "sweepAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/core/particles/ParticleTypes;SWEEP_ATTACK:Lnet/minecraft/core/particles/SimpleParticleType;"
            )
    )
    private <T extends class_2394> class_2400 sweepAttack2(class_2400 original) {
        if (((LivingEntityAccess) pe).isOffhand()) return ParticleInit.OFFHAND_SWEEPING;
        return original;
    }

    @ModifyArg(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;setItemInHand(Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"
            )
    )
    private class_1268 handArgSwap(class_1268 hand) {
        if (((LivingEntityAccess) pe).isOffhand())
            return switch (hand) {
                case field_5808 -> class_1268.field_5810;
                case field_5810 -> class_1268.field_5808;
            };
        return hand;
    }

    @Unique
    public float dualWielding$getDestroySpeed(class_2680 state) {
        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(true);
        float f = pe.method_6079().method_7924(state);
        if (f > 1.0F) {
            f += (float) ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51581);
        }

        if (class_1292.method_5576(pe)) {
            f *= 1.0F + (class_1292.method_5575(pe) + 1) * 0.2F;
        }

        if (pe.method_6059(class_1294.field_5901)) {
            float g = switch (Objects.requireNonNull(pe.method_6112(class_1294.field_5901)).method_5578()) {
                case 0 -> 0.3F;
                case 1 -> 0.09F;
                case 2 -> 0.0027F;
                default -> 8.1E-4F;
            };
            f *= g;
        }

        f *= (float) ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_49076);
        if (pe.method_5777(class_3486.field_15517)) {
            f *= (float) ((LivingEntityAccess) pe).offhandAttributes().method_26852(class_5134.field_51576);
        }

        if (!pe.method_24828()) {
            f /= 5.0F;
        }

        ((LivingEntityAccess) pe).dualWielding$setMainHandStack(false);
        return f;
    }

    @Inject(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;getMainHandItem()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private void swapResetter(CallbackInfo ci) {
        class_1799 itemStack = pe.method_6079();
        if (!class_1799.method_7973(this.lastItemInOffhand, itemStack)) {
            if (!class_1799.method_7984(this.lastItemInOffhand, itemStack)) {
                this.dualWielding$resetAttackStrengthTicker();
            }

            this.lastItemInOffhand = itemStack.method_7972();
        }
    }

    @ModifyVariable(
            method = "attack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"
            ),
            ordinal = 3,
            name = "i"
    )
    private float fixDamage(float value) {
        return modifyDamage(value, pe);
    }

    @ModifyReturnValue(
            method = "getItemBySlot",
            at = @At(
                    value = "RETURN",
                    ordinal = 0
            )
    )
    private class_1799 slotFixer(class_1799 original) {
        if (((LivingEntityAccess)pe).isOffhand())
            return (class_1799)this.inventory.field_7544.getFirst();
        return original;
    }

    @ModifyReturnValue(
            method = "getCurrentItemAttackStrengthDelay",
            at = @At("TAIL")
    )
    private float fixASpd(float value) {
        return modifyASpd(value, pe, class_1268.field_5808);
    }

}
