package eva.dualwielding.network;

import eva.dualwielding.DualWieldingServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8732;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public record ListPayload(int[] rawIds) implements class_8710, class_2596<class_8732> {
    public static final class_9154<ListPayload> ID = new class_9154<>(DualWieldingServer.LIST_PACKET_ID);
    public static final class_9139<class_2540, ListPayload> CODEC = class_2596.method_56443(ListPayload::write, ListPayload::new);
    private static final class_9145<ListPayload> CONFIG_LIST = new class_9145<>(class_2598.field_11942, ID.comp_2242());


    private ListPayload(class_2540 buf) {
        this(read(buf));
    }

    public ListPayload(List<String> ids) {
        this(asIntArray(ids));
    }

    private static int[] read(class_2540 buf) {
        List<Integer> rawIds = new ArrayList<>();
        while (buf.readableBytes() >= 4)
            rawIds.add(buf.readInt());
        int[] ids = new int[rawIds.size()];
        for (int i = 0; i < rawIds.size(); i++)
            ids[i] = rawIds.get(i);
        return ids;
    }

    private void write(class_2540 buf) {
        buf.method_52986(buf.maxCapacity());
        int i;
        for (i = 0; buf.writableBytes() >= 4 && i < rawIds.length; i++) {
            buf.method_53002(rawIds[i]);
        }
        buf.method_52986(buf.writerIndex());
    }

    private static int[] asIntArray(List<String> ids) {
        int[] rawIds = new int[ids.size()];
        for (int i = 0; i < ids.size(); i++) {
            if (Objects.equals(ids.get(i), ""))
                rawIds[i] = 0;
            else
                rawIds[i] = class_7923.field_41178.method_10206(class_7923.field_41178.method_63535(class_2960.method_60654(ids.get(i))));
        }
        return rawIds;
    }

    private static List<String> asStringList(int[] rawIds) {
        List<String> ids = new ArrayList<>();
        for (int rawId : rawIds) {
            if (rawId == 0)
                ids.add("");
            else
                ids.add(class_7923.field_41178.method_10221(class_7923.field_41178.method_10200(rawId)).toString());
        }
        return ids;
    }

    public List<String> getList() {
        return asStringList(rawIds);
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    @Override
    public class_9145<? extends class_2596<class_8732>> method_65080() {
        return CONFIG_LIST;
    }

    @Override
    public void apply(class_8732 listener) {}
}