/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding;

import eva.dualwielding.config.ConditionalBehavior;
import eva.dualwielding.config.ItemCat;
import eva.dualwielding.config.JsonConfigHelper;
import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.network.ConfigPayload;
import eva.dualwielding.network.ListPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingServer
implements DedicatedServerModInitializer {
    private static SimplyDualWieldingConfig SERVER_INSTANCE;
    public static final class_2960 CONFIG_PACKET_ID;
    public static final class_2960 LIST_PACKET_ID;
    public static final String MOD_ID = "sdw-server";
    public static final Logger LOGGER;

    public void onInitializeServer() {
        JsonConfigHelper.init();
        SERVER_INSTANCE = SimplyDualWieldingConfig.getInstance();
        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ConfigPayload.ID)) {
                LOGGER.info("sending config");
                handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)new ConfigPayload(SERVER_INSTANCE)));
                LOGGER.info("config sent");
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration not supported by client"));
            }
        });
        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ListPayload.ID)) {
                LOGGER.info("sending lists");
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<ItemCat> condition = new ArrayList<ItemCat>(List.of(new ItemCat[]{ItemCat.WHITELIST, ItemCat.BLACKLIST}));
                if (condition.contains((Object)SERVER_INSTANCE.getAttacks())) {
                    list.addAll(SERVER_INSTANCE.getAttackItems());
                }
                list.add("");
                if (condition.contains((Object)SERVER_INSTANCE.getMines())) {
                    list.addAll(SERVER_INSTANCE.getMineItems());
                }
                list.add("");
                if (SERVER_INSTANCE.getRestrictUse() != ConditionalBehavior.NEVER) {
                    list.addAll(SERVER_INSTANCE.getDisableUseItems());
                }
                list.add("");
                while (!list.isEmpty()) {
                    List<String> sub = list.subList(0, Math.min(list.size(), 8));
                    handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)new ListPayload(sub)));
                    list.removeAll(sub);
                    if (list.isEmpty() || Objects.equals(list.getLast(), "")) continue;
                    list.add("");
                }
                LOGGER.info("lists sent");
            }
        });
    }

    static {
        CONFIG_PACKET_ID = class_2960.method_60655((String)"eva", (String)"dual_config");
        LIST_PACKET_ID = class_2960.method_60655((String)"eva", (String)"config_list");
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

