/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.dualwielding.DualWieldingClient;
import eva.dualwielding.config.SimplyDualWieldingConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File simplydualwieldingConfig;
    public static Gson configGson;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            simplydualwieldingConfig = new File(folder, "simplydualwielding.json");
            if (simplydualwieldingConfig.exists()) {
                try {
                    String simplydualwieldingConfigJson = Files.readString(Path.of(simplydualwieldingConfig.getPath(), new String[0]));
                    seemsValid = simplydualwieldingConfigJson.trim().startsWith("{");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!simplydualwieldingConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    DualWieldingClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    simplydualwieldingConfig.createNewFile();
                    String json = configGson.toJson((Object)SimplyDualWieldingConfig.getInstance());
                    FileWriter writer = new FileWriter(simplydualwieldingConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void readFromConfig() {
        try {
            SimplyDualWieldingConfig config = (SimplyDualWieldingConfig)configGson.fromJson((Reader)new FileReader(simplydualwieldingConfig), SimplyDualWieldingConfig.class);
            SimplyDualWieldingConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)SimplyDualWieldingConfig.getInstance());
            FileWriter writer = new FileWriter(simplydualwieldingConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
    }
}

