/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.ClientManagerAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.config.ConfigInterpreter;
import eva.dualwielding.network.AttackPayload;
import eva.dualwielding.util.IsMining;
import eva.dualwielding.util.LastAct;
import eva.dualwielding.util.OffhandAttack;
import eva.dualwielding.util.OffhandMine;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public class MinecraftClientMixin {
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_636 field_1761;
    @Shadow
    @Nullable
    public class_239 field_1765;
    @Unique
    private int secondAttackCooldown;
    @Unique
    private boolean held = false;
    @Unique
    private LastAct noSwap = LastAct.NULL;
    @Unique
    private IsMining isMining = IsMining.NULL;
    @Unique
    private final class_310 tMc = (class_310)this;
    @Unique
    private boolean breaki = false;

    @Inject(method={"doItemUse"}, at={@At(value="RETURN")})
    private void spamFixer(CallbackInfo ci) {
        this.held = false;
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;handleInputEvents()V")})
    public void tickTickTick(CallbackInfo ci) {
        if (this.secondAttackCooldown > 0) {
            --this.secondAttackCooldown;
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ActionResult$Success;swingSource()Lnet/minecraft/util/ActionResult$SwingSource;")}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/util/ActionResult$Success;swingSource()Lnet/minecraft/util/ActionResult$SwingSource;", ordinal=2, shift=At.Shift.BEFORE))})
    private void set(CallbackInfo ci) {
        this.noSwap = LastAct.USE;
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipUse(CallbackInfo ci) {
        if (this.noSwap == LastAct.ATTACK && this.held) {
            this.doUseHit(ci, class_1268.field_5810, (class_1269)new class_1269.class_9859(), true);
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;")}, cancellable=true)
    private void blockItemUseAction(CallbackInfo ci, @Local class_1268 hand) {
        if (hand.equals((Object)class_1268.field_5810) && ConfigInterpreter.checkUseRestricted(Objects.requireNonNull(this.field_1724).method_6079(), this.field_1724.method_5715())) {
            this.doUseHit(ci, class_1268.field_5810, (class_1269)new class_1269.class_9859(), true);
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z")}, cancellable=true)
    private void doUseHit(CallbackInfo ci, @Local class_1268 hand) {
        assert (this.field_1761 != null);
        class_1269 success3 = this.field_1761.method_2919((class_1657)this.field_1724, hand);
        assert (this.field_1724 != null);
        if (this.field_1724.method_6079().method_7960() || !(success3 instanceof class_1269.class_9860)) {
            this.doUseHit(ci, hand, success3, false);
        }
    }

    @Unique
    private void doUseHit(CallbackInfo ci, class_1268 hand, class_1269 actionResult3, boolean usedDirectly) {
        assert (this.field_1724 != null);
        class_1799 stack = this.field_1724.method_6079();
        if (!(!ConfigInterpreter.checkEmpty(stack) && !ConfigInterpreter.checkMiner(stack) && !ConfigInterpreter.checkAttacker(stack) || !usedDirectly && (hand != class_1268.field_5810 || this.noSwap == LastAct.USE && this.held) || !(actionResult3 instanceof class_1269.class_9857) && !(actionResult3 instanceof class_1269.class_9859) || this.field_1724.method_7325() || this.secondAttackCooldown > 0 || this.field_1765 == null || this.field_1724.method_3144())) {
            this.noSwap = LastAct.ATTACK;
            switch (this.field_1765.method_17783()) {
                case field_1331: {
                    if (!this.held && (ConfigInterpreter.checkEmpty(stack) || ConfigInterpreter.checkAttacker(stack))) {
                        ((PlayerAccess)this.field_1724).dualWielding$attackOffhand(((class_3966)this.field_1765).method_17782());
                        Objects.requireNonNull(class_310.method_1551().method_1562()).method_52787(ClientPlayNetworking.createC2SPacket((class_8710)new AttackPayload(((class_3966)this.field_1765).method_17782().method_5628())));
                        assert (this.field_1761 != null);
                        if (!this.field_1761.method_2924()) break;
                        this.secondAttackCooldown = 10;
                        break;
                    }
                    return;
                }
                case field_1332: {
                    if (!Objects.requireNonNull(this.field_1724.method_68876()).method_8386() && (ConfigInterpreter.checkEmpty(stack) || ConfigInterpreter.checkMiner(this.field_1724.method_6079()))) {
                        class_3965 blockHitResult = (class_3965)this.field_1765;
                        class_2338 blockPos = blockHitResult.method_17777();
                        assert (this.tMc.field_1687 != null);
                        if (this.tMc.field_1687.method_8320(blockPos).method_26215()) break;
                        assert (this.field_1761 != null);
                        if (!this.held) {
                            ((ClientManagerAccess)this.field_1761).dualWielding$attackBlock(blockPos, blockHitResult.method_17780());
                            break;
                        }
                        if (!this.tMc.field_1687.method_8320(blockPos).method_26215()) break;
                        this.breaki = true;
                        break;
                    }
                    return;
                }
                case field_1333: {
                    if (!this.held && (ConfigInterpreter.checkEmpty(stack) || ConfigInterpreter.checkAttacker(this.field_1724.method_6079()))) {
                        assert (this.field_1761 != null);
                        if (this.field_1761.method_2924()) {
                            this.secondAttackCooldown = 10;
                        }
                        ((PlayerAccess)this.field_1724).dualWielding$resetLastAttackTicks();
                        break;
                    }
                    return;
                }
            }
            this.field_1724.method_6104(hand);
            this.held = false;
            ci.cancel();
        }
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;doItemUse()V", ordinal=1)})
    private void noHolding(CallbackInfo ci) {
        this.held = true;
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;getNetworkHandler()Lnet/minecraft/client/network/ClientPlayNetworkHandler;", shift=At.Shift.AFTER)})
    private void swapItem(CallbackInfo ci) {
        assert (this.field_1724 != null);
        OffhandAttack.setOffAttributes((class_1657)this.field_1724);
        OffhandMine.setOffAttributes((class_1657)this.field_1724);
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopSimulMine(CallbackInfo ci) {
        if (this.isMining == IsMining.OFF) {
            this.isMining = IsMining.NULL;
            ci.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/hit/BlockHitResult;getBlockPos()Lnet/minecraft/util/math/BlockPos;")})
    private void setMiningMain(CallbackInfo ci) {
        this.isMining = IsMining.MAIN;
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;handleBlockBreaking(Z)V")})
    private void handleBlockBreaking(CallbackInfo ci) {
        if (this.isMining == IsMining.MAIN) {
            this.isMining = IsMining.NULL;
        } else if (this.noSwap != LastAct.USE) {
            this.offHandMine(this.tMc.field_1755 == null && !this.breaki && this.tMc.field_1690.field_1904.method_1434() && this.tMc.field_1729.method_1613());
        }
    }

    @Unique
    private void offHandMine(boolean breaking) {
        assert (this.field_1724 != null);
        if ((ConfigInterpreter.checkEmpty(this.field_1724.method_6079()) || ConfigInterpreter.checkMiner(this.field_1724.method_6079())) && !Objects.requireNonNull(Objects.requireNonNull(this.field_1724).method_68876()).method_8386()) {
            if (!breaking) {
                this.secondAttackCooldown = 0;
            }
            if (this.secondAttackCooldown <= 0) {
                assert (this.field_1724 != null);
                if (!this.field_1724.method_6115()) {
                    if (breaking && this.field_1765 != null && this.field_1765.method_17783() == class_239.class_240.field_1332) {
                        this.isMining = IsMining.OFF;
                        class_3965 blockHitResult = (class_3965)this.field_1765;
                        class_2338 blockPos = blockHitResult.method_17777();
                        assert (this.tMc.field_1687 != null);
                        if (!this.tMc.field_1687.method_8320(blockPos).method_26215()) {
                            class_2350 direction = blockHitResult.method_17780();
                            assert (this.field_1761 != null);
                            if (((ClientManagerAccess)this.field_1761).dualWielding$updateBlockBreakingProgress(blockPos, direction)) {
                                this.tMc.field_1713.method_3054(blockPos, direction);
                                this.field_1724.method_6104(class_1268.field_5810);
                            }
                        }
                    } else {
                        assert (this.field_1761 != null);
                        ((ClientManagerAccess)this.field_1761).dualWielding$cancelBlockBreaking();
                    }
                }
            }
        }
    }
}

