package eva.dualwielding;

import eva.dualwielding.access.ServerPlayerAccess;
import eva.dualwielding.config.JsonConfigHelper;
import eva.dualwielding.init.ParticleInit;
import eva.dualwielding.network.AttackPacket;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingMain implements ModInitializer {

    public static final String MOD_ID = "sdw";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    private static boolean collectiveLoaded = false;

    public static boolean collectiveLoaded() {return collectiveLoaded;}

    @Override
    public void onInitialize() {
        JsonConfigHelper.init();
        ParticleInit.initServer();
        collectiveLoaded = FabricLoader.getInstance().isModLoaded("collective");



//        PayloadTypeRegistry.configurationS2C().register(ConfigPacket.ID, ConfigPacket.CODEC);
//        PayloadTypeRegistry.configurationS2C().register(ListPacket.ID, ListPacket.CODEC);
//        PayloadTypeRegistry.configurationS2C().register(BalancePacket.ID, BalancePacket.CODEC);
//        PayloadTypeRegistry.playC2S().register(AttackPacket.TYPE, AttackPacket.STREAM_CODEC);'


        ServerPlayNetworking.registerGlobalReceiver(AttackPacket.TYPE, (packet, player, sender) -> {
            player.method_14234();
            if (player.method_37908().method_8469(packet.entityId()) != null) {
                ((ServerPlayerAccess) player).dualWielding$attackOffhand(player.method_37908().method_8469(packet.entityId()));
            }
        });
    }
}