/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding;

import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.config.enums.BalanceMode;
import eva.dualwielding.config.enums.ConditionalBehavior;
import eva.dualwielding.config.enums.ItemCat;
import eva.dualwielding.network.BalancePacket;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingServer
implements DedicatedServerModInitializer {
    private static SimplyDualWieldingConfig SERVER_INSTANCE;
    public static final String MOD_ID = "sdw-server";
    public static final Logger LOGGER;

    public void onInitializeServer() {
        SERVER_INSTANCE = SimplyDualWieldingConfig.getInstance();
        ServerPlayConnectionEvents.JOIN.register((listener, sender, server) -> {
            LOGGER.info("sending config");
            sender.sendPacket((FabricPacket)new ConfigPacket(SERVER_INSTANCE));
            LOGGER.info("config sent");
            LOGGER.info("sending lists");
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<ItemCat> condition = new ArrayList<ItemCat>(List.of(new ItemCat[]{ItemCat.WHITELIST, ItemCat.BLACKLIST}));
            if (condition.contains((Object)SERVER_INSTANCE.getAttacks())) {
                list.addAll(SERVER_INSTANCE.getAttackItems());
            }
            list.add("");
            if (condition.contains((Object)SERVER_INSTANCE.getMines())) {
                list.addAll(SERVER_INSTANCE.getMineItems());
            }
            list.add("");
            if (SERVER_INSTANCE.getRestrictUse() != ConditionalBehavior.NEVER) {
                if (!SERVER_INSTANCE.getDisableUseItems().equals(SimplyDualWieldingConfig.getDefUseList())) {
                    list.addAll(SERVER_INSTANCE.getDisableUseItems());
                } else {
                    list.add("def");
                }
            }
            list.add("");
            while (!list.isEmpty()) {
                List<String> sub = list.subList(0, Math.min(list.size(), 8));
                sender.sendPacket((FabricPacket)new ListPacket(sub));
                list.removeAll(sub);
                if (list.isEmpty() || Objects.equals(list.getLast(), "")) continue;
                list.add("");
            }
            LOGGER.info("lists sent");
            if (SERVER_INSTANCE.getMode() != BalanceMode.PRETTY_MUCH_BALANCED) {
                LOGGER.info("sending balance");
                sender.sendPacket((FabricPacket)new BalancePacket(SERVER_INSTANCE.getValues()));
            }
        });
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

