/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding;

import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.init.ParticleInit;
import eva.dualwielding.network.BalancePacket;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingClient
implements ClientModInitializer {
    public static final String MOD_ID = "sdw-client";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sdw-client");
    private static boolean sprindicator = false;

    public static boolean sprindicator() {
        return sprindicator;
    }

    public void onInitializeClient() {
        ParticleInit.initClient();
        sprindicator = FabricLoader.getInstance().isModLoaded("sprintindicator");
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            ClientPlayNetworking.registerGlobalReceiver(ConfigPacket.TYPE, (packet, player, sender) -> {
                SimplyDualWieldingConfig.onConfigReceived(packet);
                LOGGER.info("applied server config");
            });
            ClientPlayNetworking.registerGlobalReceiver(ListPacket.TYPE, (packet, player, sender) -> {
                SimplyDualWieldingConfig.onListReceived(packet);
                LOGGER.info("applied server lists");
            });
            ClientPlayNetworking.registerGlobalReceiver(BalancePacket.TYPE, (packet, player, sender) -> {
                SimplyDualWieldingConfig.onBalanceReceived(packet);
                LOGGER.info("applied server balance");
            });
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("Removing server config");
            client.execute(SimplyDualWieldingConfig::disconnect);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("Removing server config; failed config!");
            client.execute(SimplyDualWieldingConfig::disconnect);
            ClientPlayNetworking.unregisterGlobalReceiver(ConfigPacket.TYPE);
            ClientPlayNetworking.unregisterGlobalReceiver(ListPacket.TYPE);
            ClientPlayNetworking.unregisterGlobalReceiver(BalancePacket.TYPE);
        });
    }
}

