package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.access.MultiPlayerGameModeAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2792;
import net.minecraft.class_2846;
import net.minecraft.class_2846.class_2847;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.dualwielding.access.ServerboundPlayerActionPacketAccess.createPacket;
import static eva.dualwielding.config.ConfigInterpreter.checkRM;

@Environment(EnvType.CLIENT)
@Mixin(class_636.class)
public class MultiPlayerGameModeMixin implements MultiPlayerGameModeAccess {

    @Final
    @Shadow
    private class_310 minecraft;
    @Shadow
    private class_1934 localPlayerMode;
    @Shadow
    private class_2338 destroyBlockPos;
    @Shadow
    private class_1799 destroyingItem;
    @Shadow
    private boolean isDestroying;

    @Unique
    private final class_636 gm = (class_636) (Object) this;
    @Unique
    private boolean isBreaking;

    @Unique
    public boolean dualWielding$startDestroyBlock(class_2338 pos, class_2350 direction) {
        assert this.minecraft.field_1724 != null;
        boolean varHolder = ((LivingEntityAccess) this.minecraft.field_1724).isOffhand();
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(true);
        boolean bl = gm.method_2910(pos, direction);
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(varHolder);
        return bl;
    }

//    @ModifyExpressionValue(
//            method = "startDestroyBlock",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/player/LocalPlayer;blockActionRestricted(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/GameType;)Z"
//            )
//    )
//    private boolean checkBlockActionRestricted(boolean original, @Local(argsOnly = true) BlockPos pos) {
//        if (this.isOffhand()) {
//            assert this.minecraft.player != null;
//            return ((PlayerAccess) this.minecraft.player).dualWielding$blockActionRestricted(this.minecraft.level, pos, this.localPlayerMode);
//        }
//        return original;
//    }

    @ModifyExpressionValue(
            method = "startDestroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;sameDestroyTarget(Lnet/minecraft/core/BlockPos;)Z"
            )
    )
    private boolean isSameDestroyTarget(boolean original, @Local(argsOnly = true) class_2338 pos) {
        if (this.isOffhand()) return this.dualWielding$sameDestroyTarget(pos);
        return original;
    }

    @Inject(
            method = "startDestroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V",
                    shift = At.Shift.AFTER
            )
    )
    private void sameDestroyTarget(class_2338 loc, class_2350 face, CallbackInfoReturnable<Boolean> cir) {
        if (this.isOffhand()) {
            assert this.minecraft.field_1724 != null;
            this.destroyingItem = this.minecraft.field_1724.method_6079();
        }
    }

    @ModifyArg(
            method = "startDestroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"
            )
    )
    private class_2596<class_2792> packetReplacer1(class_2596<class_2792> packet, @Local(argsOnly = true) class_2350 direction) {
        if (this.isOffhand()) return createPacket(class_2847.field_12971, this.destroyBlockPos, direction);
        return packet;
    }

    @ModifyExpressionValue(
            method = "startDestroyBlock",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;isDestroying:Z",
                    opcode = Opcodes.GETFIELD
            )
    )
    private boolean replaceIsDestroying(boolean original) {
        if (this.isOffhand()) return this.isBreaking;
        return original;
    }

    @Inject(
            method = "startDestroyBlock",
            at = @At("TAIL")
    )
    private void replaceIsDestroying1(class_2338 loc, class_2350 face, CallbackInfoReturnable<Boolean> cir) {
        if (this.isOffhand()) {
            this.isBreaking = this.isDestroying;
            this.isDestroying = false;
        }
    }

    @Unique
    public void dualWielding$stopDestroyBlock() {
        boolean varHolder = this.isOffhand();
        this.offhand(true);
        gm.method_2925();
        this.offhand(varHolder);
    }

    @ModifyExpressionValue(
            method = "stopDestroyBlock",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;isDestroying:Z",
                    opcode = Opcodes.GETFIELD
            )
    )
    private boolean replaceIsDestroying3(boolean original) {
        if (this.isOffhand()) return this.isBreaking;
        return this.isDestroying;
    }

    @Redirect(
            method = "stopDestroyBlock",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;isDestroying:Z",
                    opcode = Opcodes.PUTFIELD
            )
    )
    private void replaceIsDestroying4(class_636 instance, boolean value) {
        if (this.isOffhand()) this.isBreaking = value;
        else this.isDestroying = value;
    }

//    @Redirect(
//            method = "stopDestroyBlock",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/player/LocalPlayer;resetAttackStrengthTicker()V"
//            )
//    )
//    private void attackTickReset(LocalPlayer player) {
//        if (this.isOffhand())
//            ((PlayerAccess) player).dualWielding$resetAttackStrengthTicker();
//        else
//            player.resetAttackStrengthTicker();
//    }

    @Unique
    public boolean dualWielding$continueDestroyBlock(class_2338 pos, class_2350 direction) {
        assert minecraft.field_1687 != null;
        if (checkRM(minecraft.field_1687.method_8320(pos).method_26204())) return false;
        boolean varHolder = this.isOffhand();
        this.offhand(true);
        boolean bl = gm.method_2902(pos, direction);
        this.offhand(varHolder);
        return bl;
    }

    @Redirect(
            method = "continueDestroyBlock",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;isDestroying:Z",
                    opcode = Opcodes.PUTFIELD
            )
    )
    private void replaceIsDestroying5(class_636 instance, boolean value) {
        if (this.isOffhand()) this.isBreaking = value;
        else this.isDestroying = value;
    }

    @ModifyExpressionValue(
            method = "continueDestroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;sameDestroyTarget(Lnet/minecraft/core/BlockPos;)Z"
            )
    )
    private boolean sameTarget(boolean original, @Local(argsOnly = true) class_2338 pos) {
        if (this.isOffhand()) return this.dualWielding$sameDestroyTarget(pos);
        return original;
    }

    @Redirect(
            method = "continueDestroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"
            )
    )
    private boolean destroyBlockStarter(class_636 instance, class_2338 loc, class_2350 face) {
        if (this.isOffhand()) return this.dualWielding$startDestroyBlock(loc, face);
        return gm.method_2910(loc, face);
    }

    @Unique
    public boolean dualWielding$sameDestroyTarget(class_2338 pos) {
        assert this.minecraft.field_1724 != null;
//        if (this.offHandStack == null) {
//            this.offHandStack = this.minecraft.player.getOffhandItem();
//        }
        boolean varHolder = this.isOffhand();
        this.offhand(true);
        boolean bl = gm.method_2922(pos);
        this.offhand(varHolder);
        return bl;
    }

    @ModifyExpressionValue(
            method = "sameDestroyTarget",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getMainHandItem()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 handSwap(class_1799 original) {
        if (this.isOffhand()) {
            assert this.minecraft.field_1724 != null;
            return this.minecraft.field_1724.method_6079();
        }
        return original;
    }

//    @ModifyExpressionValue(
//            method = "sameDestroyTarget",
//            at = @At(
//                    value = "FIELD",
//                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;destroyingItem:Lnet/minecraft/world/item/ItemStack;"
//            )
//    )
//    private ItemStack breakingItemRep(ItemStack original) {
//        if (isOffhand) return this.offHandStack;
//        return original;
//    }

    @Inject(
            method = "destroyBlock",
            at = @At("HEAD"),
            cancellable = true
    )
    private void destroyCancel(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        assert minecraft.field_1687 != null;
        if (this.isOffhand() && checkRM(minecraft.field_1687.method_8320(pos).method_26204())) {
            cir.setReturnValue(false);
            cir.cancel();
        }
    }

//    @ModifyExpressionValue(
//            method = "destroyBlock",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/player/LocalPlayer;blockActionRestricted(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/GameType;)Z"
//            )
//    )
//    private boolean swapBool(boolean original, @Local(argsOnly = true) BlockPos pos) {
//        if (this.isOffhand()) {
//            assert this.minecraft.player != null;
//            return ((PlayerAccess) this.minecraft.player).dualWielding$blockActionRestricted(this.minecraft.level, pos, localPlayerMode);
//        }
//        return original;
//    }

    @ModifyExpressionValue(
            method = "destroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getMainHandItem()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 itemSwap(class_1799 original) {
        if (this.isOffhand()) {
            assert this.minecraft.field_1724 != null;
            return this.minecraft.field_1724.method_6079();
        }
        return original;
    }

    @ModifyArg(
            method = "startPrediction",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V"
            )
    )
    private class_2596<class_2792> packetReplacer(class_2596<class_2792> packet) {
        if (packet instanceof class_2846 returnal)
            if (this.isOffhand()) return createPacket(returnal);
        return packet;
    }
    
    @Unique
    private boolean isOffhand() {
        assert this.minecraft.field_1724 != null;
        return ((LivingEntityAccess) this.minecraft.field_1724).isOffhand();
    }

    @Unique
    private void offhand(boolean val) {
        assert this.minecraft.field_1724 != null;
        ((LivingEntityAccess) this.minecraft.field_1724).offhand(val);
    }
}
