package eva.dualwielding.mixin.client;

import eva.dualwielding.access.BlockAccess;
import eva.dualwielding.access.ClientManagerAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.MinePayload;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5552;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7204;

@Mixin(class_636.class)
public class ClientPlayerInteractionManagerMixin implements ClientManagerAccess {

    @Final @Shadow private class_310 client;
    @Final @Shadow private class_634 networkHandler;
    @Shadow private class_1934 gameMode;
    @Shadow private class_2338 currentBreakingPos;
    @Shadow private int blockBreakingCooldown;
    @Shadow private float blockBreakingSoundCooldown;
    @Shadow private float currentBreakingProgress = 0.0F;
    @Shadow private boolean breakingBlock = false;

    @Unique private class_1799 offHandStack;

    @Unique
    public boolean dualWielding$attackBlock(class_2338 pos, class_2350 direction) {
        assert this.client.field_1724 != null;
        if (((PlayerAccess) client.field_1724).dualWielding$isBlockBreakingRestricted(client.field_1687, pos, gameMode)) {
            return false;
        } else {
            assert client.field_1687 != null;
            if (!client.field_1687.method_8621().method_11952(pos)) {
                return false;
            } else {
                if (this.client.field_1724.method_31549().field_7477) {
                    class_2680 blockState = client.field_1687.method_8320(pos);
                    this.client.method_1577().method_4907(client.field_1687, pos, blockState, 1.0F);
                    this.dualWielding$sendSequencedPacket(client.field_1687, sequence -> {
                        this.dualWielding$breakBlock(pos);
                        return new MinePayload(class_2846.class_2847.field_12968, pos, direction, sequence);
                    });
                    this.blockBreakingCooldown = 5;
                } else if (!this.breakingBlock || !this.dualWielding$isCurrentlyBreaking(pos)) {
                    if (this.breakingBlock) {
                        this.networkHandler.method_52787(new MinePayload(class_2846.class_2847.field_12971, this.currentBreakingPos, direction));
                    }

                    assert this.client.field_1687 != null;
                    class_2680 blockState = this.client.field_1687.method_8320(pos);
                    this.client.method_1577().method_4907(this.client.field_1687, pos, blockState, 0.0F);
                    this.dualWielding$sendSequencedPacket(this.client.field_1687, (sequence) -> {
                        boolean bl = !blockState.method_26215();
                        if (bl && this.currentBreakingProgress == 0.0F) {
                            blockState.method_26179(this.client.field_1687, pos, this.client.field_1724);
                        }

                        if (bl && ((BlockAccess)blockState).dualWielding$calcBlockBreakingDelta(this.client.field_1724, this.client.field_1724.method_37908(), pos) >= 1.0F) {
                            this.dualWielding$breakBlock(pos);
                        } else {
                            this.breakingBlock = true;
                            this.currentBreakingPos = pos;
                            this.offHandStack = this.client.field_1724.method_6079();
                            this.currentBreakingProgress = 0.0F;
                            this.blockBreakingSoundCooldown = 0.0F;
                            this.client.field_1687.method_8517(this.client.field_1724.method_5628(), this.currentBreakingPos, this.dualWielding$getBlockBreakingProgress());
                        }

                        return new MinePayload(class_2846.class_2847.field_12968, pos, direction, sequence);
                    });
                }

                return true;
            }
        }
    }

    @Unique
    public void dualWielding$cancelBlockBreaking() {
        if (this.breakingBlock) {
            assert this.client.field_1687 != null;
            class_2680 blockState = this.client.field_1687.method_8320(this.currentBreakingPos);
            this.client.method_1577().method_4907(this.client.field_1687, this.currentBreakingPos, blockState, -1.0F);
            this.networkHandler.method_52787(new MinePayload(class_2846.class_2847.field_12971, this.currentBreakingPos, class_2350.field_11033));
            this.breakingBlock = false;
            this.currentBreakingProgress = 0.0F;
            assert this.client.field_1724 != null;
            this.client.field_1687.method_8517(this.client.field_1724.method_5628(), this.currentBreakingPos, -1);
            ((PlayerAccess) this.client.field_1724).dualWielding$resetLastAttackTicks();
        }
    }

    @Unique
    public boolean dualWielding$updateBlockBreakingProgress(class_2338 pos, class_2350 direction) {
        if (this.blockBreakingCooldown > 0) {
            this.blockBreakingCooldown--;
            return true;
        } else {
            assert this.client.field_1724 != null;
            if (this.client.field_1724.method_31549().field_7477 && Objects.requireNonNull(this.client.field_1687).method_8621().method_11952(pos)) {
                this.blockBreakingCooldown = 5;
                class_2680 blockState = this.client.field_1687.method_8320(pos);
                this.client.method_1577().method_4907(this.client.field_1687, pos, blockState, 1.0F);
                dualWielding$sendSequencedPacket(this.client.field_1687, (sequence) -> {
                    this.dualWielding$breakBlock(pos);
                    return new MinePayload(class_2846.class_2847.field_12968, pos, direction, sequence);
                });
                return true;
            } else if (this.dualWielding$isCurrentlyBreaking(pos)) {
                assert this.client.field_1687 != null;
                class_2680 blockState = this.client.field_1687.method_8320(pos);
                if (blockState.method_26215()) {
                    this.breakingBlock = false;
                    return false;
                } else {
                    this.currentBreakingProgress += ((BlockAccess) blockState).dualWielding$calcBlockBreakingDelta(this.client.field_1724, this.client.field_1724.method_37908(), pos);
                    if (this.blockBreakingSoundCooldown % 4.0F == 0.0F) {
                        class_2498 blockSoundGroup = blockState.method_26231();
                        this.client
                                .method_1483()
                                .method_4873(
                                        new class_1109(
                                                blockSoundGroup.method_10596(),
                                                class_3419.field_15245,
                                                (blockSoundGroup.method_10597() + 1.0F) / 8.0F,
                                                blockSoundGroup.method_10599() * 0.5F,
                                                class_1113.method_43221(),
                                                pos
                                        )
                                );
                    }

                    this.blockBreakingSoundCooldown++;
                    this.client.method_1577().method_4907(this.client.field_1687, pos, blockState, class_3532.method_15363(this.currentBreakingProgress, 0.0F, 1.0F));
                    if (this.currentBreakingProgress >= 1.0F) {
                        this.breakingBlock = false;
                        this.dualWielding$sendSequencedPacket(this.client.field_1687, (sequence) -> {
                            this.dualWielding$breakBlock(pos);
                            return new MinePayload(class_2846.class_2847.field_12973, pos, direction, sequence);
                        });
                        this.currentBreakingProgress = 0.0F;
                        this.blockBreakingSoundCooldown = 0.0F;
                        this.blockBreakingCooldown = 5;
                    }

                    assert this.client.field_1687 != null;
                    this.client.field_1687.method_8517(this.client.field_1724.method_5628(), this.currentBreakingPos, this.dualWielding$getBlockBreakingProgress());
                    return true;
                }
            } else {
                return this.dualWielding$attackBlock(pos, direction);
            }
        }
    }

    @Unique
    public boolean dualWielding$isCurrentlyBreaking(class_2338 pos) {
        assert this.client.field_1724 != null;
        if (this.offHandStack == null) {
            this.offHandStack = this.client.field_1724.method_6079();
        }
        class_1799 itemStack = this.client.field_1724.method_6079();
        return pos.equals(this.currentBreakingPos) && class_1799.method_31577(itemStack, this.offHandStack);
    }

    @Unique
    public void dualWielding$breakBlock(class_2338 pos) {
        assert this.client.field_1724 != null;
        if (!((PlayerAccess)this.client.field_1724).dualWielding$isBlockBreakingRestricted(this.client.field_1687, pos, gameMode)) {
            class_1937 world = this.client.field_1687;
            assert world != null;
            class_2680 blockState = world.method_8320(pos);
            if (this.client.field_1724.method_6079().method_66334(blockState, world, pos, this.client.field_1724)) {
                class_2248 block = blockState.method_26204();
                if (!(block instanceof class_5552 && !this.client.field_1724.method_7338())) {
                    if (!blockState.method_26215()) {
                        block.method_9576(world, pos, blockState, this.client.field_1724);
                        class_3610 fluidState = world.method_8316(pos);
                        boolean bl = world.method_8652(pos, fluidState.method_15759(), class_2248.field_31022);
                        if (bl) {
                            block.method_9585(world, pos, blockState);
                        }
                    }
                }
            }
        }
    }

    @Shadow(prefix = "dualWielding$")
    private void dualWielding$sendSequencedPacket(class_638 world, class_7204 packetCreator) {}

    @Unique
    public int dualWielding$getBlockBreakingProgress() {
        return this.currentBreakingProgress > 0.0F ? (int) (this.currentBreakingProgress * 10.0F) : -1;
    }

}
