package eva.dualwielding.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.DualWieldingMain;
import eva.dualwielding.access.BlockAccess;
import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.access.ServerPlayerGameModeAccess;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1890;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2846.class_2847;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_3225.class)
public abstract class ServerPlayerGameModeMixin implements ServerPlayerGameModeAccess {

    @Shadow
    public abstract boolean destroyBlock(class_2338 pos);

    @Final @Shadow protected class_3222 player;
    @Shadow protected class_3218 level;
    @Shadow private class_1934 gameModeForPlayer;
    @Shadow private int delayedTickStart;
    @Shadow private int destroyProgressStart;
    @Shadow private boolean hasDelayedDestroy;
    @Shadow private class_2338 delayedDestroyPos;
    @Shadow private class_2338 destroyPos;
    @Shadow private int lastSentState;
    @Shadow private boolean isDestroyingBlock;

    @Shadow private int gameTicks;

    @Unique private boolean isOffMine = false;

    @Inject(
            method = "tick",
            at = @At(value = "RETURN")
    )
    public void tick(CallbackInfo ci) {
        if (isOffMine) {
            ((LivingEntityAccess) player).dualWielding$setMainHandStack(true);
            if (hasDelayedDestroy) {
                class_2680 blockState = level.method_8320(delayedDestroyPos);
                if (blockState.method_26215()) {
                    hasDelayedDestroy = false;
                } else {
                    float f = dualWielding$incrementDestroyProgress(blockState, delayedDestroyPos, delayedTickStart);
                    if (f >= 1.0F) {
                        hasDelayedDestroy = false;
                        dualWielding$destroyBlock(delayedDestroyPos);
                    }
                }
            } else if (isDestroyingBlock) {
                class_2680 blockState = level.method_8320(destroyPos);
                if (blockState.method_26215()) {
                    level.method_8517(player.method_5628(), destroyPos, -1);
                    lastSentState = -1;
                    isOffMine = false;
                    isDestroyingBlock = false;
                } else {
                    dualWielding$incrementDestroyProgress(blockState, destroyPos, destroyProgressStart);
                }
            }
            ((LivingEntityAccess) player).dualWielding$setMainHandStack(false);
        }
    }

    @Unique
    public void dualWielding$handleBlockBreakingAction(class_2338 pos, class_2847 action, class_2350 direction, int worldHeight, int sequence) {
        if (!player.method_56093(pos, 1.0)) {
            dualWielding$debugLogging(pos, false, sequence, "too far");
        } else if (pos.method_10264() > worldHeight) {
            player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
            dualWielding$debugLogging(pos, false, sequence, "too high");
        } else {
            if (action == class_2847.field_12968) {
                isOffMine = true;
                if (!level.method_8505(player, pos)) {
                    player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
                    dualWielding$debugLogging(pos, false, sequence, "may not interact");
                    return;
                }

                if (((PlayerAccess)player).dualWielding$blockActionRestricted(level, pos, gameModeForPlayer)) {
                    player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
                    dualWielding$debugLogging(pos, false, sequence, "block action restricted");
                    return;
                }

                destroyProgressStart = gameTicks;
                float f = 1.0F;
                class_2680 blockState = level.method_8320(pos);
                if (!blockState.method_26215()) {
                    class_1890.method_60124(
                            level,
                            player.method_6079(),
                            player,
                            player,
                            class_1304.field_6173,
                            class_243.method_24953(pos),
                            blockState,
                            item -> player.method_20235(item, class_1304.field_6171)
                    );
                    blockState.method_26179(level, pos, player);
                    f = ((BlockAccess)blockState).dualWielding$getDestroyProgress(player, level, pos);
                }

                if (!blockState.method_26215() && f >= 1.0F) {
                    this.dualWielding$destroyAndAck(pos, sequence, "insta mine");
                } else {
                    if (isDestroyingBlock) {
                        player.field_13987.method_14364(new class_2626(destroyPos, level.method_8320(destroyPos)));
                        dualWielding$debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                    }
                    
                    isOffMine = true;
                    isDestroyingBlock = true;
                    destroyPos = pos.method_10062();
                    int i = (int)(f * 10.0F);
                    level.method_8517(player.method_5628(), pos, i);
                    dualWielding$debugLogging(pos, true, sequence, "actual start of destroying");
                    lastSentState = i;
                }
            } else if (action == class_2847.field_12973) {
                isOffMine = false;
                if (pos.equals(destroyPos)) {
                    int j = gameTicks - destroyProgressStart;
                    class_2680 blockStatex = level.method_8320(pos);
                    if (!blockStatex.method_26215()) {
                        float g = ((BlockAccess)blockStatex).dualWielding$getDestroyProgress(player, level, pos) * (j + 1);
                        if (g >= 0.7F) {
                            isOffMine = false;
                            isDestroyingBlock = false;
                            level.method_8517(player.method_5628(), pos, -1);
                            this.dualWielding$destroyAndAck(pos, sequence, "destroyed");
                            return;
                        }
                        PlayerBlockBreakEvents.CANCELED.invoker().onBlockBreakCanceled(level, player, pos, blockStatex, level.method_8321(pos));
                        if (!hasDelayedDestroy) {
                            isOffMine = false;
                            isDestroyingBlock = false;
                            hasDelayedDestroy = true;
                            delayedDestroyPos = pos;
                            delayedTickStart = destroyProgressStart;
                        }
                    }
                }

                dualWielding$debugLogging(pos, true, sequence, "stopped destroying");
            } else if (action == class_2847.field_12971) {
                isOffMine = false;
                isDestroyingBlock = false;
                if (!Objects.equals(destroyPos, pos)) {
                    DualWieldingMain.LOGGER.warn("Mismatch in destroy block pos: {} {}", destroyPos, pos);
                    level.method_8517(player.method_5628(), destroyPos, -1);
                    dualWielding$debugLogging(pos, true, sequence, "aborted mismatched destroying");
                }

                level.method_8517(player.method_5628(), pos, -1);
                dualWielding$debugLogging(pos, true, sequence, "aborted destroying");
            }
        }
    }

    @Unique
    public float dualWielding$incrementDestroyProgress(class_2680 state, class_2338 pos, int startTick) {
        int i = this.gameTicks - startTick;
        float f = ((BlockAccess)state).dualWielding$getDestroyProgress(player, level, pos) * (i + 1);
        int j = (int)(f * 10.0F);
        if (j != lastSentState) {
            this.level.method_8517(player.method_5628(), pos, j);
            this.lastSentState = j;
        }
        return f;
    }

    @Unique
    public void dualWielding$destroyAndAck(class_2338 pos, int sequence, String reason) {
        ((LivingEntityAccess) player).dualWielding$setMainHandStack(true);
        if (dualWielding$destroyBlock(pos)) {
            dualWielding$debugLogging(pos, true, sequence, reason);
        } else {
            player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
            dualWielding$debugLogging(pos, false, sequence, reason);
        }
        ((LivingEntityAccess) player).dualWielding$setMainHandStack(false);
    }

    @ModifyExpressionValue(
            method = "destroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerPlayer;hasCorrectToolForDrops(Lnet/minecraft/world/level/block/state/BlockState;)Z"
            )
    )
    private boolean hasCorrectToolForDrops(boolean original, @Local class_2680 blockState) {
        if (((LivingEntityAccess) player).isOffhand()) return ((PlayerAccess)player).dualWielding$hasCorrectToolForDrops(blockState);
        return original;
    }

    @Unique
    public boolean dualWielding$destroyBlock(class_2338 pos) {
        return ((class_3225) (Object) this).method_14266(pos);
    }

//    @Unique
//    public boolean dualWielding$destroyBlock(BlockPos pos) {
//        BlockState blockState = level.getBlockState(pos);
//        if (!player.getOffhandItem().canDestroyBlock(blockState, level, pos, player)) {
//            return false;
//        } else {
//            BlockEntity blockEntity = level.getBlockEntity(pos);
//            Block block = blockState.getBlock();
//            if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
//                level.sendBlockUpdated(pos, blockState, blockState, 3);
//                return false;
//            } else if (this.player.blockActionRestricted(this.level, pos, this.gameModeForPlayer)) {
//                return false;
//            } else {
//                BlockState blockState2 = block.playerWillDestroy(this.level, pos, blockState, this.player);
//                boolean bl = this.level.removeBlock(pos, false);
//                if (bl) {
//                    block.destroy(this.level, pos, blockState2);
//                }
//
//                if (this.player.preventsBlockDrops()) {
//                    return true;
//                } else {
//                    ItemStack itemStack = this.player.getMainHandItem();
//                    ItemStack itemStack2 = itemStack.copy();
//                    boolean bl2 = this.player.hasCorrectToolForDrops(blockState2);
//                    itemStack.mineBlock(this.level, blockState2, pos, this.player);
//                    if (bl && bl2) {
//                        block.playerDestroy(this.level, this.player, pos, blockState2, blockEntity, itemStack2);
//                    }
//
//                    return true;
//                }
//            }
//        }
//    }

    @Shadow(prefix = "dualWielding$")
    private void dualWielding$debugLogging(class_2338 pos, boolean success, int sequence, String reason) {}
}
