package eva.dualwielding;

import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.config.enums.BalanceMode;
import eva.dualwielding.config.enums.ConditionalBehavior;
import eva.dualwielding.config.enums.ItemCat;
import eva.dualwielding.network.BalancePacket;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static eva.dualwielding.network.BalancePacket.BALANCE_PACKET_ID;
import static eva.dualwielding.network.ConfigPacket.CONFIG_PACKET_ID;
import static eva.dualwielding.network.ListPacket.LIST_PACKET_ID;

public class DualWieldingServer implements DedicatedServerModInitializer {

    private static SimplyDualWieldingConfig SERVER_INSTANCE;



    public static final String MOD_ID = DualWieldingMain.MOD_ID + "-server";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    @Override
    public void onInitializeServer() {

        SERVER_INSTANCE = SimplyDualWieldingConfig.getInstance();

        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend(handler, CONFIG_PACKET_ID)) {
                LOGGER.info("sending config");
                handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new ConfigPacket(SERVER_INSTANCE)));

                LOGGER.info("config sent");
            } else {
//              You can opt to disconnect the client if it cannot handle the configuration task
                handler.method_52396(class_2561.method_43470("Network configuration not supported by client"));
            }
        if (ServerConfigurationNetworking.canSend(handler, LIST_PACKET_ID)) {
                LOGGER.info("sending lists");
                List<String> list = new ArrayList<>();
                List<ItemCat> condition = new ArrayList<>(List.of(new ItemCat[]{ItemCat.WHITELIST, ItemCat.BLACKLIST}));
                if (condition.contains(SERVER_INSTANCE.getAttacks()))
                    list.addAll(SERVER_INSTANCE.getAttackItems());
                list.add("");
                if (condition.contains(SERVER_INSTANCE.getMines()))
                    list.addAll(SERVER_INSTANCE.getMineItems());
                list.add("");
                if (SERVER_INSTANCE.getRestrictUse() != ConditionalBehavior.NEVER)
                    if (!SERVER_INSTANCE.getDisableUseItems().equals(SimplyDualWieldingConfig.getDefUseList()))
                        list.addAll(SERVER_INSTANCE.getDisableUseItems());
                    else
                        list.add("def");
                list.add("");
                while (!list.isEmpty()) {
                    List<String> sub = list.subList(0, Math.min(list.size(), 8));
                    handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new ListPacket(sub)));
                    list.removeAll(sub);
                    if (!list.isEmpty() && !Objects.equals(list.getLast(), "")) list.add("");
                }

                LOGGER.info("lists sent");

            }
        if (ServerConfigurationNetworking.canSend(handler, BALANCE_PACKET_ID)) {
                if (SERVER_INSTANCE.getMode() != BalanceMode.PRETTY_MUCH_BALANCED) {
                    LOGGER.info("sending balance");
                    handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new BalancePacket(SERVER_INSTANCE.getValues())));
                }
            }
        });
    }
}
