package eva.dualwielding.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import eva.dualwielding.config.enums.BalanceMode;
import eva.dualwielding.config.enums.ConditionalBehavior;
import eva.dualwielding.config.enums.ItemCat;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;

import static eva.dualwielding.config.SimplyDualWieldingConfig.*;

public class SimplyDualWieldingConfigScreen  implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("Simply Dual Wielding Config"))
                .setSavingRunnable(JsonConfigHelper::writeToConfig)
                .setEditable(true);
        SimplyDualWieldingConfig INSTANCE = getInstance();
        SimplyDualWieldingConfig SERVER_INSTANCE = getServerInstance();
        if (SERVER_INSTANCE != null) {
            builder.getOrCreateCategory(class_2561.method_43470("Server Settings"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Hit with empty offhand:"),
                                    SERVER_INSTANCE.getEmpty())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(0))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Offhand Weapons:"),
                                    ItemCat.class, SERVER_INSTANCE.getAttacks())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(1))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Offhand Mining Tools:"),
                                    ItemCat.class, SERVER_INSTANCE.getMines())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(2))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Disable Listed Item Use in Offhand:"),
                                    ConditionalBehavior.class, SERVER_INSTANCE.getRestrictUse())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(3))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Server balance mode:"),
                                    BalanceMode.class, SERVER_INSTANCE.getMode())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build());
            builder.getOrCreateCategory(class_2561.method_43470("Server Lists"))
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Attacking Items"),
                                    SERVER_INSTANCE.getAttackItems())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Mining Items"),
                                    SERVER_INSTANCE.getMineItems())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Offhand Use Disabled Items"),
                                    SERVER_INSTANCE.getDisableUseItems())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build());
            if (SERVER_INSTANCE.getMode() == BalanceMode.CUSTOM_BALANCE)
                builder.getOrCreateCategory(class_2561.method_43470("Server Factors:"))
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Dual wielding damage factor:"),
                                        SERVER_INSTANCE.getDualDamageFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("One handed damage factor:"),
                                        SERVER_INSTANCE.getOneHandedDamageFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Two handed damage factor:"),
                                        SERVER_INSTANCE.getTwoHandedDamageFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Dual wielding speed factor:"),
                                        SERVER_INSTANCE.getDualSpeedFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("One handed speed factor:"),
                                        SERVER_INSTANCE.getOneHandedSpeedFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build())
                        .addEntry(builder.entryBuilder()
                                .startDoubleField(class_2561.method_43470("Two handed speed factor:"),
                                        SERVER_INSTANCE.getTwoHandedSpeedFactor())
                                .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                                .build());
        }
        builder.getOrCreateCategory(class_2561.method_43470("Basic Settings"))
                .addEntry(builder.entryBuilder()
                        .startBooleanToggle(class_2561.method_43470("Hit with empty offhand:"),
                                INSTANCE.getEmpty())
                        .setDefaultValue(false)
                        .setTooltip(class_2561.method_43470("WARNING: The offhand will still\nnot render if it didn't\nalready!\n\nALSO:\nthis will override all other\nsettings"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setEmpty)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Offhand Weapons"),
                                ItemCat.class, INSTANCE.getAttacks())
                        .setDefaultValue(ItemCat.ALL)
                        .setTooltip(class_2561.method_43470("lmk if tools or weapons don't\ninclude a tool or weapon from\nvanilla or a mod"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setAttacks)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Offhand Mining Tools"),
                                ItemCat.class, INSTANCE.getMines())
                        .setDefaultValue(ItemCat.ALL)
                        .setTooltip(class_2561.method_43470("lmk if tools or weapons don't\ninclude a tool or weapon from\nvanilla or a mod"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setMines)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Restrict offhand use actions:"),
                                ConditionalBehavior.class, INSTANCE.getRestrictUse())
                        .setDefaultValue(ConditionalBehavior.SNEAKING_ONLY)
                        .setTooltip(class_2561.method_43470("Disables offhand 'use' actions\nfor items in the relevant list"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setRestrictUse)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Server balance mode:"),
                                BalanceMode.class, INSTANCE.getMode())
                        .setDefaultValue(BalanceMode.PRETTY_MUCH_BALANCED)
                        .setSaveConsumer(SimplyDualWieldingConfig::setMode)
                        .setTooltip(class_2561.method_43470("Determines damage & speed factors for\nitems with attribute modifiers for those attributes\n\nDual_wielding_is_broken: always 1.0x\nPetty_much_balanced:\n    dual gets 0.8x\n    one-handed gets 1.0x\n    two-handed gets 1.2x\n\nCheck the Factors tab for more info!"))
                        .build());
        builder.getOrCreateCategory(class_2561.method_43470("Lists"))
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Attacking Items"),
                                INSTANCE.getAttackItems())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE."))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(getDef())
                        .setSaveConsumer(SimplyDualWieldingConfig::setAttackItems)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Mining Items"),
                                INSTANCE.getMineItems())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE."))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(getDef())
                        .setSaveConsumer(SimplyDualWieldingConfig::setMineItems)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Use Action Disabled Items"),
                                INSTANCE.getDisableUseItems())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE."))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(getDefUseList())
                        .setSaveConsumer(SimplyDualWieldingConfig::setDisableUseItems)
                        .build());
        builder.getOrCreateCategory(class_2561.method_43470("Factors"))
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Dual wielding damage:"),
                                INSTANCE.getDualDamageFactor())
                        .setSaveConsumer(SimplyDualWieldingConfig::setDualDamageFactor)
                        .setDefaultValue(0.8)
                        .setTooltip(class_2561.method_43470("Affects damage when both hands have\nan item with a combat attribute modifier\n(e.g. tools, weapons)"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("One handed damage:"),
                                INSTANCE.getOneHandedDamageFactor())
                        .setSaveConsumer(SimplyDualWieldingConfig::setOneHandedDamageFactor)
                        .setDefaultValue(1.0)
                        .setTooltip(class_2561.method_43470("Affects damage when both hands are full\nbut only one has an item with\na combat attribute modifier"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Two handed damage:"),
                                INSTANCE.getTwoHandedDamageFactor())
                        .setSaveConsumer(SimplyDualWieldingConfig::setTwoHandedDamageFactor)
                        .setDefaultValue(1.2)
                        .setTooltip(class_2561.method_43470("Affects damage when only one hand is full,\nand the item in it has a\ncombat attribute modifier"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Dual wielding attack speed:"),
                                INSTANCE.getDualSpeedFactor())
                        .setSaveConsumer(SimplyDualWieldingConfig::setDualSpeedFactor)
                        .setDefaultValue(0.8)
                        .setTooltip(class_2561.method_43470("Affects attack speed when both hands have\nan item with a combat attribute modifier\n(e.g. tools, weapons)"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("One handed attack speed:"),
                                INSTANCE.getOneHandedSpeedFactor())
                        .setSaveConsumer(SimplyDualWieldingConfig::setOneHandedSpeedFactor)
                        .setDefaultValue(1.0)
                        .setTooltip(class_2561.method_43470("Affects attack speed when both hands are full\nbut only one has an item with\na combat attribute modifier"))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startDoubleField(class_2561.method_43470("Two handed attack speed:"),
                                INSTANCE.getTwoHandedSpeedFactor())
                        .setSaveConsumer(SimplyDualWieldingConfig::setTwoHandedSpeedFactor)
                        .setDefaultValue(1.2)
                        .setTooltip(class_2561.method_43470("Affects attack speed when only one hand is full,\nand the item in it has a\ncombat attribute modifier"))
                        .build());
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }
}