package eva.dualwielding.mixin;

import eva.dualwielding.DualWieldingMain;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.MinePacket;
import eva.dualwielding.util.OffhandMine;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_5552;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_3225.class)
public class ServerPlayerGameModeMixin implements eva.dualwielding.access.ServerPlayerGameModeMixin {
    
    @Final @Shadow protected class_3222 player;
    @Shadow protected class_3218 level;
    @Shadow private class_1934 gameModeForPlayer;
    @Shadow private int delayedTickStart;
    @Shadow private int destroyProgressStart;
    @Shadow private boolean hasDelayedDestroy;
    @Shadow private class_2338 delayedDestroyPos;
    @Shadow private class_2338 destroyPos;
    @Shadow private int lastSentState;
    @Shadow private boolean isDestroyingBlock;

    @Shadow private int gameTicks;
    @Unique private int useTickCounter() {
        return gameTicks + 1;
    }

    @Inject(method = "tick", at = @At(value = "HEAD"))
    public void doUpdate(CallbackInfo ci) {
        ((PlayerAccess) player).dualWielding$setMainHandStack(true);
        if (hasDelayedDestroy) {
            class_2680 blockState = level.method_8320(delayedDestroyPos);
            if (blockState.method_26215()) {
                hasDelayedDestroy = false;
            } else {
                float f = dualWielding$continueMining(blockState, delayedDestroyPos, delayedTickStart);
                if (f >= 1.0F) {
                    hasDelayedDestroy = false;
                    dualWielding$tryBreakBlock(delayedDestroyPos);
                }
            }
        } else if (isDestroyingBlock) {
            class_2680 blockState = level.method_8320(destroyPos);
            if (blockState.method_26215()) {
                level.method_8517(player.method_5628(), destroyPos, -1);
                lastSentState = -1;
                isDestroyingBlock = false;
            } else {
                dualWielding$continueMining(blockState, destroyPos, destroyProgressStart);
            }
        }
        ((PlayerAccess) player).dualWielding$setMainHandStack(false);
    }

    @Unique
    public void dualWielding$processBlockBreakingAction(class_2338 pos, MinePacket.MinePayload.Action action, class_2350 direction, int worldHeight, int sequence) {
        if (!player.method_56093(pos, 1.0)) {
            dualWielding$debugLogging(pos, false, sequence, "too far");
        } else if (pos.method_10264() > worldHeight) {
            player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
            dualWielding$debugLogging(pos, false, sequence, "too high");
        } else {
            if (action == MinePacket.MinePayload.Action.START_DESTROY_BLOCK) {
                if (!level.method_8505(player, pos)) {
                    player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
                    dualWielding$debugLogging(pos, false, sequence, "may not interact");
                    return;
                }

                if (!((PlayerAccess)player).dualWielding$isBlockBreakingRestricted(level, pos, gameModeForPlayer)) {
                    player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
                    dualWielding$debugLogging(pos, false, sequence, "block action restricted");
                    return;
                }

                destroyProgressStart = useTickCounter();
                float f = 1.0F;
                class_2680 blockState = level.method_8320(pos);
                if (!blockState.method_26215()) {
                    class_1890.method_60124(
                            level,
                            player.method_6079(),
                            player,
                            player,
                            class_1304.field_6173,
                            class_243.method_24953(pos),
                            blockState,
                            item -> player.method_20235(item, class_1304.field_6171)
                    );
                    blockState.method_26179(level, pos, player);
                    f = OffhandMine.calcBlockBreakingDelta(blockState, player, player.method_37908(), pos);
//                    f = ((BlockAccess)blockState).dualWielding$calcBlockBreakingDelta(player, player.getWorld(), pos);
                }

                if (!blockState.method_26215() && f >= 1.0F) {
                    dualWielding$finishMining(pos, sequence, "insta mine");
                } else {
                    if (isDestroyingBlock) {
                        player.field_13987.method_14364(new class_2626(destroyPos, level.method_8320(destroyPos)));
                        dualWielding$debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                    }

                    isDestroyingBlock = true;
                    destroyPos = pos.method_10062();
                    int i = (int)(f * 10.0F);
                    level.method_8517(player.method_5628(), pos, i);
                    dualWielding$debugLogging(pos, true, sequence, "actual start of destroying");
                    lastSentState = i;
                }
            } else if (action == MinePacket.MinePayload.Action.STOP_DESTROY_BLOCK) {
                if (pos.equals(destroyPos)) {
                    int j = useTickCounter() - destroyProgressStart;
                    class_2680 blockStatex = level.method_8320(pos);
                    if (!blockStatex.method_26215()) {
                        float g = OffhandMine.calcBlockBreakingDelta(blockStatex, player, player.method_37908(), pos) * (j + 1);
//                        float g = ((BlockAccess)blockStatex).dualWielding$calcBlockBreakingDelta(player, player.getWorld(), pos) * (j + 1);
                        if (g >= 0.7F) {
                            isDestroyingBlock = false;
                            level.method_8517(player.method_5628(), pos, -1);
                            dualWielding$finishMining(pos, sequence, "destroyed");
                            return;
                        }

                        if (!hasDelayedDestroy) {
                            isDestroyingBlock = false;
                            hasDelayedDestroy = true;
                            delayedDestroyPos = pos;
                            delayedTickStart = destroyProgressStart;
                        }
                    }
                }

                dualWielding$debugLogging(pos, true, sequence, "stopped destroying");
            } else if (action == MinePacket.MinePayload.Action.ABORT_DESTROY_BLOCK) {
                isDestroyingBlock = false;
                if (!Objects.equals(destroyPos, pos)) {
                    DualWieldingMain.LOGGER.warn("Mismatch in destroy block pos: {} {}", destroyPos, pos);
                    level.method_8517(player.method_5628(), destroyPos, -1);
                    dualWielding$debugLogging(pos, true, sequence, "aborted mismatched destroying");
                }

                level.method_8517(player.method_5628(), pos, -1);
                dualWielding$debugLogging(pos, true, sequence, "aborted destroying");
            }
        }
    }

    @Unique
    public float dualWielding$continueMining(class_2680 state, class_2338 pos, int failedStartMiningTime) {
        int i = useTickCounter() - failedStartMiningTime;
//        float f = ((BlockAccess)state).dualWielding$calcBlockBreakingDelta(player, player.getWorld(), pos) * (i + 1);
        float f = OffhandMine.calcBlockBreakingDelta(state, player, player.method_37908(), pos) * (i + 1);
        int j = (int)(f * 10.0F);
        if (j != lastSentState) {
            level.method_8517(player.method_5628(), pos, j);
            lastSentState = j;
        }
        return f;
    }

    @Unique
    public void dualWielding$finishMining(class_2338 pos, int sequence, String reason) {
        if (dualWielding$tryBreakBlock(pos)) {
            dualWielding$debugLogging(pos, true, sequence, reason);
        } else {
            player.field_13987.method_14364(new class_2626(pos, level.method_8320(pos)));
            dualWielding$debugLogging(pos, false, sequence, reason);
        }

    }

    @Unique
    public boolean dualWielding$tryBreakBlock(class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        if (!player.method_6079().method_7909().method_7885(blockState, level, pos, player)) {
            return false;
        } else {
            class_2586 blockEntity = level.method_8321(pos);
            class_2248 block = blockState.method_26204();
            if (block instanceof class_5552 && !player.method_7338()) {
                level.method_8413(pos, blockState, blockState, 3);
                return false;
            } else if (player.method_21701(level, pos, gameModeForPlayer)) {
                return false;
            } else {
                class_2680 blockState2 = block.method_9576(level, pos, blockState, player);
                if (!PlayerBlockBreakEvents.BEFORE.invoker().beforeBlockBreak(level, player, pos, blockState2,blockEntity))
                    return false;
                boolean bl = level.method_8650(pos, false);
                if (bl) {
                    block.method_9585(level, pos, blockState2);
                }

                if (!player.method_7337()) {
                    class_1799 itemStack = player.method_6079();
                    class_1799 itemStack2 = itemStack.method_7972();
                    boolean bl2 = ((PlayerAccess)player).dualWielding$canHarvest(blockState2);
                    itemStack.method_7952(level, blockState2, pos, player);
                    if (bl && bl2) {
                        block.method_9556(level, player, pos, blockState2, blockEntity, itemStack2);
                    }
                }
                return true;
            }
        }
    }

    @Shadow(prefix = "dualWielding$")
    private void dualWielding$debugLogging(class_2338 pos, boolean success, int sequence, String reason) {}
}
