package eva.dualwielding.mixin.client;

import eva.dualwielding.access.MultiPlayerGameModeAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.MinePacket;
import eva.dualwielding.util.OffhandMine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5552;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7204;

import static eva.dualwielding.config.ConfigInterpreter.checkRM;

@Mixin(class_636.class)
public class MultiPlayerGameModeMixin implements MultiPlayerGameModeAccess {

    @Final @Shadow private class_310 minecraft;
    @Final @Shadow private class_634 connection;
    @Shadow private class_1934 localPlayerMode;
    @Shadow private class_2338 destroyBlockPos;
    @Shadow private int destroyDelay;
    @Shadow private float destroyTicks;
    @Shadow private float destroyProgress;
    @Shadow private boolean isDestroying;

    @Unique private class_1799 offHandStack;

    @Unique
    public boolean dualWielding$attackBlock(class_2338 pos, class_2350 direction) {
        assert this.minecraft.field_1724 != null;
        if (((PlayerAccess) minecraft.field_1724).dualWielding$isBlockBreakingRestricted(minecraft.field_1687, pos, localPlayerMode)) {
            return false;
        } else {
            assert minecraft.field_1687 != null;
            if (!minecraft.field_1687.method_8621().method_11952(pos)) {
                return false;
            } else {
                if (this.minecraft.field_1724.method_7337()) {
                    class_2680 blockState = minecraft.field_1687.method_8320(pos);
                    this.minecraft.method_1577().method_4907(minecraft.field_1687, pos, blockState, 1.0F);
                    this.dualWielding$startPrediction(minecraft.field_1687, sequence -> {
                        this.dualWielding$breakBlock(pos);
                        return new MinePacket(pos, direction, MinePacket.MinePayload.Action.START_DESTROY_BLOCK, sequence);
                    });
                    this.destroyDelay = 5;
                } else if (!this.isDestroying || !this.dualWielding$isCurrentlyBreaking(pos)) {
                    if (this.isDestroying) {
                        this.connection.method_52787(new MinePacket(this.destroyBlockPos, direction, MinePacket.MinePayload.Action.ABORT_DESTROY_BLOCK));
                    }

                    assert this.minecraft.field_1687 != null;
                    class_2680 blockState = this.minecraft.field_1687.method_8320(pos);
                    this.minecraft.method_1577().method_4907(this.minecraft.field_1687, pos, blockState, 0.0F);
                    this.dualWielding$startPrediction(this.minecraft.field_1687, (sequence) -> {
                        boolean bl = !blockState.method_26215();
                        if (bl && this.destroyProgress == 0.0F) {
                            blockState.method_26179(this.minecraft.field_1687, pos, this.minecraft.field_1724);
                        }
                        ((PlayerAccess)this.minecraft.field_1724).dualWielding$setMainHandStack(true);
                        if (bl && OffhandMine.calcBlockBreakingDelta(blockState, this.minecraft.field_1724, this.minecraft.field_1687, pos) >= 1.0F) {
                            this.dualWielding$breakBlock(pos);
                        } else {
                            this.isDestroying = true;
                            this.destroyBlockPos = pos;
                            this.offHandStack = this.minecraft.field_1724.method_6079();
                            this.destroyProgress = 0.0F;
                            this.destroyTicks = 0.0F;
                            this.minecraft.field_1687.method_8517(this.minecraft.field_1724.method_5628(), this.destroyBlockPos, this.dualWielding$getBlockBreakingProgress());
                        }
                        ((PlayerAccess)this.minecraft.field_1724).dualWielding$setMainHandStack(false);

                        return new MinePacket(pos, direction,MinePacket.MinePayload.Action.START_DESTROY_BLOCK, sequence);
                    });
                }

                return true;
            }
        }
    }

    @Unique
    public void dualWielding$cancelBlockBreaking() {
        if (this.isDestroying) {
            assert this.minecraft.field_1687 != null;
            class_2680 blockState = this.minecraft.field_1687.method_8320(this.destroyBlockPos);
            this.minecraft.method_1577().method_4907(this.minecraft.field_1687, this.destroyBlockPos, blockState, -1.0F);
            this.connection.method_52787(new MinePacket(this.destroyBlockPos, class_2350.field_11033, MinePacket.MinePayload.Action.ABORT_DESTROY_BLOCK));
            this.isDestroying = false;
            this.destroyProgress = 0.0F;
            assert this.minecraft.field_1724 != null;
            this.minecraft.field_1687.method_8517(this.minecraft.field_1724.method_5628(), this.destroyBlockPos, -1);
            ((PlayerAccess) this.minecraft.field_1724).dualWielding$resetLastAttackTicks();
        }
    }

    @Unique
    public boolean dualWielding$updateBlockBreakingProgress(class_2338 pos, class_2350 direction) {
        assert minecraft.field_1687 != null;
        if (checkRM(minecraft.field_1687.method_8320(pos).method_26204())) return true;
        if (this.destroyDelay > 0) {
            this.destroyDelay--;
            return true;
        } else {
            assert this.minecraft.field_1724 != null;
            if (this.minecraft.field_1724.method_7337() && Objects.requireNonNull(this.minecraft.field_1687).method_8621().method_11952(pos)) {
                this.destroyDelay = 5;
                class_2680 blockState = this.minecraft.field_1687.method_8320(pos);
                this.minecraft.method_1577().method_4907(this.minecraft.field_1687, pos, blockState, 1.0F);
                dualWielding$startPrediction(this.minecraft.field_1687, (sequence) -> {
                    this.dualWielding$breakBlock(pos);
                    return new MinePacket(pos, direction, MinePacket.MinePayload.Action.START_DESTROY_BLOCK, sequence);
                });
                return true;
            } else if (this.dualWielding$isCurrentlyBreaking(pos)) {
                assert this.minecraft.field_1687 != null;
                class_2680 blockState = this.minecraft.field_1687.method_8320(pos);
                if (blockState.method_26215()) {
                    this.isDestroying = false;
                    return false;
                } else {
                    ((PlayerAccess)this.minecraft.field_1724).dualWielding$setMainHandStack(true);
                    float f = OffhandMine.calcBlockBreakingDelta(blockState, this.minecraft.field_1724, this.minecraft.field_1687, pos);
//                    float f = ((BlockAccess) blockState).dualWielding$calcBlockBreakingDelta(this.client.player, this.client.player.getWorld(), pos);
                    ((PlayerAccess)this.minecraft.field_1724).dualWielding$setMainHandStack(false);
                    this.destroyProgress += f;
                    if (this.destroyTicks % 4.0F == 0.0F) {
                        class_2498 blockSoundGroup = blockState.method_26231();
                        this.minecraft
                                .method_1483()
                                .method_4873(
                                        new class_1109(
                                                blockSoundGroup.method_10596(),
                                                class_3419.field_15245,
                                                (blockSoundGroup.method_10597() + 1.0F) / 8.0F,
                                                blockSoundGroup.method_10599() * 0.5F,
                                                class_1113.method_43221(),
                                                pos
                                        )
                                );
                    }

                    this.destroyTicks++;
                    this.minecraft.method_1577().method_4907(this.minecraft.field_1687, pos, blockState, class_3532.method_15363(this.destroyProgress, 0.0F, 1.0F));
                    if (this.destroyProgress >= 1.0F) {
                        this.isDestroying = false;
                        this.dualWielding$startPrediction(this.minecraft.field_1687, (sequence) -> {
                            this.dualWielding$breakBlock(pos);
                            return new MinePacket(pos, direction, MinePacket.MinePayload.Action.STOP_DESTROY_BLOCK, sequence);
                        });
                        this.destroyProgress = 0.0F;
                        this.destroyTicks = 0.0F;
                        this.destroyDelay = 5;
                    }

                    assert this.minecraft.field_1687 != null;
                    assert this.minecraft.field_1724 != null;
                    this.minecraft.field_1687.method_8517(this.minecraft.field_1724.method_5628(), this.destroyBlockPos, this.dualWielding$getBlockBreakingProgress());
                    return true;
                }
            } else {
                return this.dualWielding$attackBlock(pos, direction);
            }
        }
    }

    @Unique
    public boolean dualWielding$isCurrentlyBreaking(class_2338 pos) {
        assert this.minecraft.field_1724 != null;
        if (this.offHandStack == null) {
            this.offHandStack = this.minecraft.field_1724.method_6079();
        }
        class_1799 itemStack = this.minecraft.field_1724.method_6079();
        return pos.equals(this.destroyBlockPos) && class_1799.method_7984(itemStack, this.offHandStack);
    }

    @Unique
    public void dualWielding$breakBlock(class_2338 pos) {
        assert minecraft.field_1687 != null;
        if (checkRM(minecraft.field_1687.method_8320(pos).method_26204())) return;
        assert this.minecraft.field_1724 != null;
        if (!((PlayerAccess)this.minecraft.field_1724).dualWielding$isBlockBreakingRestricted(this.minecraft.field_1687, pos, localPlayerMode)) {
            class_1937 world = this.minecraft.field_1687;
            assert world != null;
            class_2680 blockState = world.method_8320(pos);
            if (this.minecraft.field_1724.method_6079().method_7909().method_7885(blockState, world, pos, this.minecraft.field_1724)) {
                class_2248 block = blockState.method_26204();
                if (!(block instanceof class_5552 && !this.minecraft.field_1724.method_7338())) {
                    if (!blockState.method_26215()) {
                        block.method_9576(world, pos, blockState, this.minecraft.field_1724);
                        class_3610 fluidState = world.method_8316(pos);
                        boolean bl = world.method_8652(pos, fluidState.method_15759(), class_2248.field_31022);
                        if (bl) {
                            block.method_9585(world, pos, blockState);
                        }
                    }
                }
            }
        }
    }

    @Shadow(prefix = "dualWielding$")
    private void dualWielding$startPrediction(class_638 world, class_7204 packetCreator) {}

    @Unique
    public int dualWielding$getBlockBreakingProgress() {
        return this.destroyProgress > 0.0F ? (int) (this.destroyProgress * 10.0F) : -1;
    }

}
