package eva.dualwielding.mixin;

import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.util.DualWieldingOffhandAttack;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_1657.class, priority = 1001)
public abstract class PlayerEntityMixin extends class_1309 implements PlayerAccess {

    @Unique
    private int lastAttackedOffhandTicks;

    public PlayerEntityMixin(class_1937 world) {
        super(class_1299.field_6097, world);
    }

    @Inject(method = "tick()V", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/player/PlayerEntity;lastAttackedTicks:I", ordinal = 0))
    private void tickMixin(CallbackInfo info) {
        lastAttackedOffhandTicks++;
    }

    @Unique
    public float getOffhandAttackCooldownProgressPerTick() {
        return DualWieldingOffhandAttack.getOffhandAttackCooldownProgressPerTick((class_1657) (Object) this);
    }

    @Override
    public void attackOffhand(class_1297 target) {
        DualWieldingOffhandAttack.offhandAttack((class_1657) (Object) this, target);
    }

    @Override
    public void resetLastDualOffhandAttackTicks() {
        this.lastAttackedOffhandTicks = 0;
    }

    @Override
    public float getAttackCooldownProgressDualOffhand(float baseTime) {
        return class_3532.method_15363(((float) this.lastAttackedOffhandTicks + baseTime) / this.getOffhandAttackCooldownProgressPerTick(), 0.0F, 1.0F);
    }

}
