package eva.dualwielding.mixin.client;

import eva.dualwielding.access.PlayerAccess;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_759;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_759.class)
public class HeldItemRendererMixin {
    @Shadow
    private float equipProgressOffHand;
    @Shadow
    private float equipProgressMainHand;

    @Shadow
    @Final
    @Mutable
    private class_310 client;

    @Shadow
    private class_1799 offHand;

    @Unique
    private float equipOffhand;
    @Unique
    private boolean isOffhandAttack;

    public HeldItemRendererMixin(class_310 client) {
        this.client = client;
    }

    @Inject(method = "updateHeldItems", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/util/math/MathHelper;clamp(FFF)F", ordinal = 3, shift = Shift.AFTER), locals = LocalCapture.CAPTURE_FAILSOFT)
    public void updateHeldItemsMixin(CallbackInfo info, class_746 clientPlayerEntity, class_1799 itemStack, class_1799 itemStack2) {
        float o = ((PlayerAccess) clientPlayerEntity).getAttackCooldownProgressDualOffhand(1.0F);
        if (o < 0.1F) this.isOffhandAttack = true;
//        this.equipOffhand = 1.0F;
        if (this.isOffhandAttack) {
            if (this.equipProgressMainHand >= 1.0F) {
                this.isOffhandAttack = false;
            }
            this.equipOffhand += class_3532.method_15363((this.offHand == itemStack2 ? o * o * o : 0.0F) - this.equipOffhand, -0.4F, 0.4F);
            this.equipProgressOffHand = this.equipOffhand;
        }
    }

    @Inject(method = "updateHeldItems", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getAttackCooldownProgress(F)F"))
    public void updateHeldMainhandMixin(CallbackInfo info) {
        assert client.field_1724 != null;
        float o = ((PlayerAccess) client.field_1724).getAttackCooldownProgressDualOffhand(1.0F);
        if (o < 0.9F && o > 0.15F) {
            this.offHand = new class_1799(class_1802.field_8162);
        }
    }
}
