package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.AttackPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

import static net.minecraft.class_1268.field_5810;

@Mixin(class_310.class)
@Debug(export = true)
public class MinecraftClientMixin {

    @Shadow
    @Nullable
    public class_746 player;
    @Shadow
    @Nullable
    public class_636 interactionManager;
    @Shadow
    @Nullable
    public class_239 crosshairTarget;
    @Shadow
    private int itemUseCooldown;
    @Unique
    private int secondAttackCooldown;

//    private Hand hand;
//    private ItemStack itemStack;

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/MinecraftClient;handleInputEvents()V"))
    public void tickTickTick(CallbackInfo ci) {
        if (this.secondAttackCooldown > 0) {
            --this.secondAttackCooldown;
        }
    }


    @Inject(method = "doItemUse", at = @At(value = "INVOKE",
                                        target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;interactItem(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;",
                                        shift = At.Shift.BY, by = 2),
            cancellable = true)

    private void doUseHit(CallbackInfo ci, @Local class_1268 hand, @Local class_1269 actionResult3) {
        class_310 thisMinecraftClient = (class_310) (Object) this;
        assert thisMinecraftClient.field_1761 != null;
//        ActionResult actionResult3 = thisMinecraftClient.interactionManager.interactItem(player, hand);
        if (hand != field_5810) return;
        if (hand == field_5810 && (actionResult3 instanceof class_1269.class_9857 || actionResult3 instanceof class_1269.class_9859)) {
            assert player != null;
            if (!player.method_7325()) {
                if (this.secondAttackCooldown <= 0) {
                    if (this.crosshairTarget != null && !this.player.method_3144()) {
                        switch (this.crosshairTarget.method_17783()) {
                            case field_1331:
                                // Client
                                ((PlayerAccess) this.player).resetLastDualOffhandAttackTicks();
                                ((PlayerAccess) this.player).attackOffhand(((class_3966) crosshairTarget).method_17782());

                                // Server
                                Objects.requireNonNull(class_310.method_1551().method_1562()).method_52787(ClientPlayNetworking.createC2SPacket(new AttackPayload(((class_3966) this.crosshairTarget).method_17782().method_5628())));
                                break;
                            case field_1332:
                                class_3965 blockHitResult = (class_3965) this.crosshairTarget;
                                class_2338 blockPos = blockHitResult.method_17777();
                                if (!player.method_37908().method_8320(blockPos).method_26215()) {
                                    assert this.interactionManager != null;
                                    this.interactionManager.method_2896(player, hand, blockHitResult);
                                    break;
                                }
                            case field_1333:
                                assert this.interactionManager != null;
                                if (this.interactionManager.method_2924()) {
                                    this.secondAttackCooldown = 10;
                                }
                                ((PlayerAccess) player).resetLastDualOffhandAttackTicks();
                        }
                        this.itemUseCooldown = 4;
                        this.player.method_6104(hand);
                        ci.cancel();
                    }
                }
            }
        }
    }
}