package eva.dualwielding.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import eva.dualwielding.DualWieldingClient;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;

import static eva.dualwielding.config.SimplyDualWieldingConfig.*;

public class SimplyDualWieldingConfigScreen  implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("Simply Dual Wielding Config"))
                .setSavingRunnable(JsonConfigHelper::writeToConfig)
                .setEditable(true);
        SimplyDualWieldingConfig INSTANCE = getInstance();
        SimplyDualWieldingConfig SERVER_INSTANCE = getServerInstance();
        boolean iMLoaded = DualWieldingClient.iMLoaded;
        if (SERVER_INSTANCE != null) {
            builder.getOrCreateCategory(class_2561.method_43470("Server Settings"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Hit with empty offhand:"),
                                    SERVER_INSTANCE.getEmpty())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(0))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Offhand Weapons"),
                                    ItemCat.class, SERVER_INSTANCE.getAttacks())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(1))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Offhand Mining Tools"),
                                    ItemCat.class, SERVER_INSTANCE.getMines())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(2))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Disable Listed Item Use in Offhand"),
                                    ConditionalBehavior.class, SERVER_INSTANCE.getRestrictUse())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("   Allows weaker personal setting for the above:"),
                                    SERVER_INSTANCE.getAllowWeakConfig(3))
                            .build());
            builder.getOrCreateCategory(class_2561.method_43470("Server Lists"))
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Attacking Items"),
                                    SERVER_INSTANCE.getAttackItems())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Mining Items"),
                                    SERVER_INSTANCE.getMineItems())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Offhand Use Disabled Items"),
                                    SERVER_INSTANCE.getDisableUseItems())
                            .setTooltip(class_2561.method_43470("SERVER CONFIG; CHANGES MADE HERE ARE NOT RESPECTED"))
                            .build());
        }
        builder.getOrCreateCategory(class_2561.method_43470("Basic Settings"))
                .addEntry(builder.entryBuilder()
                        .startBooleanToggle(class_2561.method_43470("Hit with empty offhand:"),
                                INSTANCE.getEmpty())
                        .setDefaultValue(false)
                        .setTooltip(class_2561.method_43470("WARNING: The offhand will still\nnot render if it didn't\nalready!\n\nALSO:\nthis will override all other\nsettings"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setEmpty)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Offhand Weapons"),
                                ItemCat.class, INSTANCE.getAttacks())
                        .setDefaultValue(ItemCat.ALL)
                        .setTooltip(class_2561.method_43470("lmk if tools or weapons don't\ninclude a tool or weapon from\nvanilla or a mod"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setAttacks)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Offhand Mining Tools"),
                                ItemCat.class, INSTANCE.getMines())
                        .setDefaultValue(ItemCat.ALL)
                        .setTooltip(class_2561.method_43470("lmk if tools or weapons don't\ninclude a tool or weapon from\nvanilla or a mod"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setMines)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Restrict offhand use actions:"),
                                ConditionalBehavior.class, INSTANCE.getRestrictUse())
                        .setDefaultValue(ConditionalBehavior.SNEAKING_ONLY)
                        .setTooltip(class_2561.method_43470("Disables offhand 'use' actions\nfor items in the relevant list"))
                        .setSaveConsumer(SimplyDualWieldingConfig::setRestrictUse)
                        .build());
        if (iMLoaded)
            builder.getOrCreateCategory(class_2561.method_43470("Interaction Manager Integration"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Offhand respects attack rules"), INSTANCE.getRespectIMAttacking())
                            .setDefaultValue(true)
                            .setTooltip(class_2561.method_43470("Determines if offhand follows\nInteractionManager's attack settings"))
                            .setSaveConsumer(SimplyDualWieldingConfig::setRespectIMAttacking)
                            .build())
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Offhand respects mining rules"), INSTANCE.getRespectIMMining())
                            .setDefaultValue(true)
                            .setTooltip(class_2561.method_43470("Determines if offhand follows\nInteractionManager's mining settings"))
                            .setSaveConsumer(SimplyDualWieldingConfig::setRespectIMMining)
                            .build());
        builder.getOrCreateCategory(class_2561.method_43470("Lists"))
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Attacking Items"),
                                INSTANCE.getAttackItems())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE."))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(getDef())
                        .setSaveConsumer(SimplyDualWieldingConfig::setAttackItems)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Mining Items"),
                                INSTANCE.getMineItems())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE."))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(getDef())
                        .setSaveConsumer(SimplyDualWieldingConfig::setMineItems)
                        .build())
                .addEntry(builder.entryBuilder()
                        .startStrList(class_2561.method_43470("Use Action Disabled Items"),
                                INSTANCE.getDisableUseItems())
                        .setInsertButtonEnabled(true)
                        .setDeleteButtonEnabled(true)
                        .setTooltip(class_2561.method_43470("Enter an item TYPE"))
                        .setCellErrorSupplier(getErrorSupplier())
                        .setDefaultValue(getDefUseList())
                        .setSaveConsumer(SimplyDualWieldingConfig::setDisableUseItems)
                        .build());
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }
}