package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.MultiPlayerGameModeAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.AttackPayload;
import eva.dualwielding.util.IsMining;
import eva.dualwielding.util.LastAct;
import eva.dualwielding.util.OffhandAttack;
import eva.dualwielding.util.OffhandMine;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

import static eva.dualwielding.config.ConfigInterpreter.*;

@Mixin(value = class_310.class, priority = 5000)
public class MinecraftMixin {

    @Shadow @Nullable public class_746 player;
    @Shadow @Nullable public class_636 gameMode;
    @Shadow @Nullable public class_239 hitResult;

    @Unique private int secondAttackCooldown;
    @Unique private boolean held = false;
    @Unique private LastAct noSwap = LastAct.NULL;
    @Unique private IsMining isMining = IsMining.NULL;
    @Unique private final class_310 tMc = (class_310) (Object) this;

    @Unique private boolean breaki = false;

    @Inject(method = "startUseItem", at = @At("RETURN"))
    private void spamFixer(CallbackInfo ci) {held = false;}

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;handleKeybinds()V"))
    public void tickTickTick(CallbackInfo ci) {
        if (this.secondAttackCooldown > 0) {
            --this.secondAttackCooldown;
        }
    }

    @Inject(
            method = "startUseItem",
            at = @At(
                    value = "RETURN"
            ),
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/world/InteractionResult;consumesAction()Z",
                            ordinal = 0
                    ),
                    to = @At(
                            value = "RETURN",
                            ordinal = 5
                    )
            )
    )
    private void set(CallbackInfo ci) {
        noSwap = LastAct.USE;
    }

    @Inject(method = "startUseItem", at = @At("HEAD"), cancellable = true)
    private void skipUse(CallbackInfo ci) {
        if (noSwap == LastAct.ATTACK && held)
            doUseHit(ci, class_1268.field_5810, class_1269.field_5811, true);
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"),
            cancellable = true)
    private void blockItemUseAction(CallbackInfo ci, @Local class_1268 hand) {
        if (hand == class_1268.field_5810 && checkUseRestricted(Objects.requireNonNull(player).method_6079(), player.method_18276()))
            doUseHit(ci, class_1268.field_5810, class_1269.field_5811, true);
    }

    @Inject(method = "startUseItem", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z"),
            cancellable = true)
    private void doUseHit(CallbackInfo ci, @Local class_1268 hand) {
        assert this.gameMode != null;
        class_1269 success3 = this.gameMode.method_2919(this.player, hand);
        assert player != null;
        if (!(!player.method_6079().method_7960() && success3 == class_1269.field_5812))
            this.doUseHit(ci, hand, success3, false);
    }

    @Unique
    private void doUseHit(CallbackInfo ci, class_1268 hand, class_1269 actionResult3, boolean usedDirectly) {
        assert player != null;
        class_1799 stack = player.method_6079();
        if (checkEmpty(stack) || !(!checkMiner(stack) && !checkAttacker(stack)))
            if (!(!usedDirectly && (hand != class_1268.field_5810 || (noSwap == LastAct.USE && held))))
                if (!actionResult3.method_23665()) {
                    if (!player.method_7325())
                        if (this.secondAttackCooldown <= 0)
                            if (this.hitResult != null && !player.method_3144()) {
                                noSwap = LastAct.ATTACK;
                                switch (Objects.requireNonNull(this.hitResult).method_17783()) {
                                    case field_1331:
                                        if (!held && (checkEmpty(stack) || checkAttacker(stack))) {
                                            // Client
                                            ((PlayerAccess) this.player).dualWielding$attackOffhand(((class_3966)hitResult).method_17782());
                                            // Server
                                            ClientPlayNetworking.send(new AttackPayload(((class_3966) this.hitResult).method_17782().method_5628()));
                                            assert this.gameMode != null;
                                            if (this.gameMode.method_2924()) {
                                                this.secondAttackCooldown = 10;
                                            }
                                        } else return;
                                        break;
                                    case field_1332:
                                        if (!(player.method_7337() && (checkEmpty(stack) || checkMiner(player.method_6079())))) {
                                            class_3965 blockHitResult = (class_3965) this.hitResult;
                                            class_2338 blockPos = blockHitResult.method_17777();
                                            assert tMc.field_1687 != null;
                                            if (!tMc.field_1687.method_8320(blockPos).method_26215()) {
                                                assert this.gameMode != null;
                                                if (!held)
                                                    ((MultiPlayerGameModeAccess) this.gameMode).dualWielding$attackBlock(blockPos, blockHitResult.method_17780());
                                                else if (tMc.field_1687.method_8320(blockPos).method_26215())
                                                    breaki = true;
                                            }
                                        } else return;
                                        break;
                                    case field_1333:
                                        if (!held && (checkEmpty(stack) || checkAttacker(player.method_6079()))) {
                                            assert this.gameMode != null;
                                            if (this.gameMode.method_2924()) {
                                                this.secondAttackCooldown = 10;
                                            }
                                            ((PlayerAccess) player).dualWielding$resetLastAttackTicks();
                                        } else return;
                                }

                                this.player.method_6104(hand);
                                held = false;
                                ci.cancel();
                            }


                }
    }

    @Inject(method = "handleKeybinds",
            at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/Minecraft;startUseItem()V",
            ordinal = 1))
    private void noHolding(CallbackInfo ci){
        held = true;
    }

    @Inject(method = "handleKeybinds",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/Minecraft;getConnection()Lnet/minecraft/client/multiplayer/ClientPacketListener;",
                    shift = At.Shift.AFTER))
    private void swapItem(CallbackInfo ci) {
        assert player != null;
        OffhandAttack.setOffAttributes(player);
        OffhandMine.setOffAttributes(player);
    }

    @Inject(method = "continueAttack", at = @At(value = "HEAD"), cancellable = true)
    private void stopSimulMine(CallbackInfo ci) {
        if (isMining == IsMining.OFF) {
            isMining = IsMining.NULL;
            ci.cancel();
        }
    }

    @Inject(method = "continueAttack",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;"))
    private void setMiningMain(CallbackInfo ci) {
        isMining = IsMining.MAIN;
    }

    @Inject(method = "handleKeybinds",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/Minecraft;continueAttack(Z)V"))
    private void handleBlockBreaking(CallbackInfo ci) {
        if (isMining == IsMining.MAIN)
            isMining = IsMining.NULL;
        else if (noSwap != LastAct.USE)
            offHandMine(tMc.field_1755 == null && !breaki && tMc.field_1690.field_1904.method_1434() && tMc.field_1729.method_1613());
    }

    @Unique
    private void offHandMine(boolean breaking) {
        assert player != null;
        if (checkEmpty(player.method_6079()) || checkMiner(player.method_6079())) {
            if (!Objects.requireNonNull(player).method_7337()) {
                if (!breaking) {
                    secondAttackCooldown = 0;
                }
                if (secondAttackCooldown <= 0) {
                    assert this.player != null;
                    if (!this.player.method_6115()) {
                        if (breaking && this.hitResult != null && this.hitResult.method_17783() == class_239.class_240.field_1332) {
                            isMining = IsMining.OFF;
                            class_3965 blockHitResult = (class_3965) this.hitResult;
                            class_2338 blockPos = blockHitResult.method_17777();
                            assert tMc.field_1687 != null;
                            if (!tMc.field_1687.method_8320(blockPos).method_26215()) {
                                class_2350 direction = blockHitResult.method_17780();
                                assert this.gameMode != null;
                                if (((MultiPlayerGameModeAccess) this.gameMode).dualWielding$updateBlockBreakingProgress(blockPos, direction)) {
                                    tMc.field_1713.method_3054(blockPos, direction);
                                    this.player.method_6104(class_1268.field_5810);
                                }
                            }
                        } else {
                            assert this.gameMode != null;
                            ((MultiPlayerGameModeAccess) this.gameMode).dualWielding$cancelBlockBreaking();
                        }
                    }
                }
            }
        }
    }
}