package eva.dualwielding.mixin;

import eva.dualwielding.access.LivingEntityAccess;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements LivingEntityAccess {

    @Unique
    private boolean isOffHand = false;

    @Inject(method = "getWeaponStack", at = @At("HEAD"), cancellable = true)
    private void weaponStackChanger(CallbackInfoReturnable<class_1799> cir) {
        if (isOffHand) {
            cir.setReturnValue(((class_1309) (Object) this).method_6079());
            cir.cancel();
        }
    }

    @Override
    public class_1309 dualWielding$setWeaponStack(boolean isOffHand) {
        this.isOffHand = isOffHand;
        return (class_1309) (Object) this;
    }
}