package eva.dualwielding;

import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.access.ServerManagerAccess;
import eva.dualwielding.init.ParticleInit;
import eva.dualwielding.network.AttackPayload;
import eva.dualwielding.network.MinePayload;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingMain implements ModInitializer {

    public static final String MOD_ID = "sdw";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_2960 ATTACK_PACKET_ID = class_2960.method_60655("eva", "off_attack");
    public static final class_2960 MINE_PACKET_ID = class_2960.method_60655("eva", "off_mine");

    @Override
    public void onInitialize() {
        ParticleInit.initServer();
        PayloadTypeRegistry.playC2S().register(AttackPayload.ID, AttackPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(AttackPayload.ID, (payload, context) -> {

            int entityId = payload.entityId();
            context.server().execute(() -> {
                class_3222 tp = context.player();
                tp.method_14234();
                if (context.player().method_37908().method_8469(entityId) != null) {
                    ((PlayerAccess) tp).dualWielding$attackOffhand(tp.method_37908().method_8469(entityId));
                }
            });
        });

        PayloadTypeRegistry.playC2S().register(MinePayload.ID, MinePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(MinePayload.ID, (payload, context) -> {
            context.server().execute(() -> {
                class_3222 tp = context.player();
                ((ServerManagerAccess)tp.field_13974).dualWielding$processBlockBreakingAction(payload.method_12362(), payload.getReal(), payload.method_12360(), tp.method_37908().method_31600(), payload.method_42079());
                    tp.field_13987.method_41255(payload.method_42079());
            });
        });
    }
}