package eva.dualwielding.config;

public class SimplyDualWieldingConfig {

    private boolean empty = false;
    private ItemCat attacks = ItemCat.ALL;
    private ItemCat mines = ItemCat.ALL;
    private final boolean[] readSinceLastUpdate = {false, false, false};
    private static SimplyDualWieldingConfig INSTANCE;

    public static SimplyDualWieldingConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimplyDualWieldingConfig();
        }

        return INSTANCE;
    }

    public void updateConfigs(SimplyDualWieldingConfig config) {
        this.empty = config.empty;
        this.attacks = config.attacks;
        this.mines = config.mines;
    }

    void setEmpty(boolean setter) {
        readSinceLastUpdate[0] = false;
        this.empty = setter;
    }
    public static boolean getEmpty() {
        getInstance().readSinceLastUpdate[0] = true;
        return getInstance().empty;
    }

    void setAttacks(ItemCat setter) {
        readSinceLastUpdate[1] = false;
        this.attacks = setter;
    }
    public static ItemCat getAttacks() {
        getInstance().readSinceLastUpdate[1] = true;
        return getInstance().attacks;
    }

    void setMines(ItemCat setter) {
        readSinceLastUpdate[2] = false;
        this.mines = setter;
    }
    public static ItemCat getMines() {
        getInstance().readSinceLastUpdate[2] = true;
        return getInstance().mines;
    }

    public static boolean[] getReadStatus() {
        return getInstance().readSinceLastUpdate;
    }

}
