package eva.dualwielding.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;

import static eva.dualwielding.config.SimplyDualWieldingConfig.getInstance;

public class SimplyDualWieldingConfigScreen  implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("Simply Dual Wielding Config"))
                .setSavingRunnable(JsonConfigHelper::writeToConfig)
                .setEditable(true);
        getInstance();
        builder.getOrCreateCategory(class_2561.method_43470("No Item"))
                .addEntry(builder.entryBuilder()
                        .startBooleanToggle(class_2561.method_43470("Empty Offhand Hits: "), SimplyDualWieldingConfig.getEmpty())
                        .setDefaultValue(false)
                        .setTooltip(class_2561.method_43470("WARNING: The offhand will still\nnot render if it didn't\nalready!\n\nANOTHER THING:\nthis will override all other\nsettings"))
                        .setSaveConsumer(newValue -> getInstance().setEmpty(newValue))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Offhand Attack with these items: "), ItemCat.class, SimplyDualWieldingConfig.getAttacks())
                        .setDefaultValue(ItemCat.ALL)
                        .setTooltip(class_2561.method_43470("Whitelist & blacklist to be implemented"))
                        .setSaveConsumer(newValue -> getInstance().setAttacks(newValue))
                        .build())
                .addEntry(builder.entryBuilder()
                        .startEnumSelector(class_2561.method_43470("Offhand Mine with these items: "), ItemCat.class, SimplyDualWieldingConfig.getMines())
                        .setDefaultValue(ItemCat.ALL)
                        .setTooltip(class_2561.method_43470("Whitelist & blacklist to be implemented"))
                        .setSaveConsumer(newValue -> getInstance().setMines(newValue))
                        .build());
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }
}
