package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.ClientManagerAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.AttackPayload;
import eva.dualwielding.util.IsMining;
import eva.dualwielding.util.LastAct;
import eva.dualwielding.util.OffhandAttack;
import eva.dualwielding.util.OffhandMine;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

import static eva.dualwielding.config.ConfigInterpreter.*;

@Mixin(class_310.class)
public class MinecraftClientMixin {

    @Shadow
    @Nullable
    public class_746 player;
    @Shadow
    @Nullable
    public class_636 interactionManager;
    @Shadow
    @Nullable
    public class_239 crosshairTarget;

    @Unique
    private int secondAttackCooldown;
    @Unique
    private boolean held = false;
    @Unique
    private LastAct noSwap = LastAct.NULL;
    @Unique
    private IsMining isMining = IsMining.NULL;
    @Unique
    private final class_310 tMc = (class_310) (Object) this;

    @Unique
    private boolean breaki = false;

    @Inject(method = "doItemUse", at = @At("RETURN"))
    public void spamFixer(CallbackInfo ci) {held = false;}

    @Inject(method = "doItemUse",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/util/ActionResult$Success;swingSource()Lnet/minecraft/util/ActionResult$SwingSource;"),
            slice = @Slice(to = @At(value = "INVOKE",
                    target = "Lnet/minecraft/util/ActionResult$Success;swingSource()Lnet/minecraft/util/ActionResult$SwingSource;",
                    ordinal = 2, shift = At.Shift.BEFORE)))
    private void set(CallbackInfo ci) {
        noSwap = LastAct.USE;
    }

    @Inject(method = "doItemUse", at = @At("HEAD"), cancellable = true)
    private void skipUse(CallbackInfo ci) {
        if (noSwap == LastAct.ATTACK && held) {
            doUseHit(ci, class_1268.field_5810, new class_1269.class_9859(), true);
        }
    }

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/MinecraftClient;handleInputEvents()V"))
    public void tickTickTick(CallbackInfo ci) {
        if (this.secondAttackCooldown > 0) {
            --this.secondAttackCooldown;
        }
    }


    @Inject(method = "doItemUse", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/item/ItemStack;isEmpty()Z"),
            cancellable = true)
    private void doUseHit(CallbackInfo ci, @Local class_1268 hand) {
        assert this.interactionManager != null;
        class_1269 success3 = this.interactionManager.method_2919(this.player, hand);
        assert player != null;
        if (!(!player.method_6079().method_7960() && success3 instanceof class_1269.class_9860))
            this.doUseHit(ci, hand, success3, false);

    }

    @Unique
    private void doUseHit(CallbackInfo ci, class_1268 hand, class_1269 actionResult3, boolean usedDirectly) {
        assert player != null;
        class_1799 stack = player.method_6079();
        if (checkEmpty(stack) || !(!checkMiner(stack) && !checkAttacker(stack)))
            if (!(!usedDirectly && (hand != class_1268.field_5810 || (noSwap == LastAct.USE && held))))
                if (actionResult3 instanceof class_1269.class_9857 || actionResult3 instanceof class_1269.class_9859) {
                    assert player != null;
                    if (!player.method_7325())
                        if (this.secondAttackCooldown <= 0)
                            if (this.crosshairTarget != null && !this.player.method_3144()) {
                                noSwap = LastAct.ATTACK;
                                switch (this.crosshairTarget.method_17783()) {
                                    case field_1331:
                                        if (!held && (checkEmpty(stack) || checkAttacker(stack))) {
                                            // Client
                                            ((PlayerAccess) this.player).dualWielding$resetLastOffhandAttackTicks();
                                            ((PlayerAccess) this.player).dualWielding$attackOffhand(((class_3966) crosshairTarget).method_17782());
                                            // Server
                                            Objects.requireNonNull(class_310.method_1551().method_1562()).method_52787(ClientPlayNetworking.createC2SPacket(new AttackPayload(((class_3966) this.crosshairTarget).method_17782().method_5628())));
                                            assert this.interactionManager != null;
                                            if (this.interactionManager.method_2924()) {
                                                this.secondAttackCooldown = 10;
                                            }
                                        } else return;
                                        break;
                                    case field_1332:
                                        if (!Objects.requireNonNull(player.method_68876()).method_8386() && (checkEmpty(stack) || checkMiner(player.method_6079()))) {
                                            class_3965 blockHitResult = (class_3965) this.crosshairTarget;
                                            class_2338 blockPos = blockHitResult.method_17777();
                                            assert tMc.field_1687 != null;
                                            if (!tMc.field_1687.method_8320(blockPos).method_26215()) {
                                                assert this.interactionManager != null;
                                                if (!held)
                                                    ((ClientManagerAccess) this.interactionManager).dualWielding$attackBlock(blockPos, blockHitResult.method_17780());
                                                else if (tMc.field_1687.method_8320(blockPos).method_26215())
                                                    breaki = true;
                                            }
                                        } else return;
                                        break;
                                    case field_1333:
                                        if (!held && (checkEmpty(stack) || checkAttacker(player.method_6079()))) {
                                            assert this.interactionManager != null;
                                            if (this.interactionManager.method_2924()) {
                                                this.secondAttackCooldown = 10;
                                            }
                                            ((PlayerAccess) player).dualWielding$resetLastOffhandAttackTicks();
                                        } else return;
                                }

                                this.player.method_6104(hand);
                                held = false;
                                ci.cancel();
                            }


                }
    }

    @Inject(method = "handleInputEvents",
            at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/MinecraftClient;doItemUse()V",
            ordinal = 1))
    private void noHolding(CallbackInfo ci){
        held = true;
    }

    @Inject(method = "handleInputEvents",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/MinecraftClient;getNetworkHandler()Lnet/minecraft/client/network/ClientPlayNetworkHandler;",
                    shift = At.Shift.AFTER))
    private void swapItem(CallbackInfo ci) {
        assert player != null;
        OffhandAttack.setOffAttributes(player);
        OffhandMine.setOffAttributes(player);
    }

    @Inject(method = "handleBlockBreaking", at = @At(value = "HEAD"), cancellable = true)
    private void stopSimulMine(CallbackInfo ci) {
        if (isMining == IsMining.OFF) {
            isMining = IsMining.NULL;
            ci.cancel();
        }
    }

    @Inject(method = "handleBlockBreaking",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/util/hit/BlockHitResult;getBlockPos()Lnet/minecraft/util/math/BlockPos;"))
    private void setMiningMain(CallbackInfo ci) {
        isMining = IsMining.MAIN;
    }

    @Inject(method = "handleInputEvents",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/MinecraftClient;handleBlockBreaking(Z)V"))
    private void handleBlockBreaking(CallbackInfo ci) {
        if (isMining == IsMining.MAIN)
            isMining = IsMining.NULL;
        else if (noSwap != LastAct.USE)
            offHandMine(tMc.field_1755 == null && !breaki && tMc.field_1690.field_1904.method_1434() && tMc.field_1729.method_1613());
    }

    @Unique
    private void offHandMine(boolean breaking) {
        assert player != null;
        if (checkEmpty(player.method_6079()) || checkMiner(player.method_6079())) {
            if (!Objects.requireNonNull(Objects.requireNonNull(player).method_68876()).method_8386()) {
                if (!breaking) {
                    secondAttackCooldown = 0;
                }
                if (secondAttackCooldown <= 0) {
                    assert this.player != null;
                    if (!this.player.method_6115()) {
                        if (breaking && this.crosshairTarget != null && this.crosshairTarget.method_17783() == class_239.class_240.field_1332) {
                            isMining = IsMining.OFF;
                            class_3965 blockHitResult = (class_3965) this.crosshairTarget;
                            class_2338 blockPos = blockHitResult.method_17777();
                            assert tMc.field_1687 != null;
                            if (!tMc.field_1687.method_8320(blockPos).method_26215()) {
                                class_2350 direction = blockHitResult.method_17780();
                                assert this.interactionManager != null;
                                if (((ClientManagerAccess) this.interactionManager).dualWielding$updateBlockBreakingProgress(blockPos, direction)) {
                                    tMc.field_1713.method_3054(blockPos, direction);
                                    this.player.method_6104(class_1268.field_5810);
                                }
                            }
                        } else {
                            assert this.interactionManager != null;
                            ((ClientManagerAccess) this.interactionManager).dualWielding$cancelBlockBreaking();
                        }
                    }
                }
            }
        }
    }
}