package eva.dualwielding.network;

import eva.dualwielding.DualWieldingMain;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2792;
import net.minecraft.class_2846;
import net.minecraft.class_8710;
import net.minecraft.class_9094;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public class MinePayload extends class_2846 implements class_8710, class_2596<class_2792> {
    public static final class_8710.class_9154<MinePayload> ID = new class_8710.class_9154<>(DualWieldingMain.MINE_PACKET_ID);
    public static final class_9139<class_2540, MinePayload> field_48207 = class_2596.method_56443(MinePayload::method_55988, MinePayload::new);

    private final class_2338 pos;
    private final class_2350 direction;
    private final class_2846.class_2847 action;
    private final int sequence;

    @Override
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    @Override
    public class_9145<class_2846> method_65080() {
        return class_9094.field_48099;
    }

    @Override
    public void method_12361(class_2792 listener) {
        listener.method_12066(this);
    }

    public MinePayload(class_2846.class_2847 action, class_2338 pos, class_2350 direction, int sequence) {
        super(action, pos.method_10062(), direction);
        this.action = action;
        this.pos = pos.method_10062();
        this.direction = direction;
        this.sequence = sequence;

    }

    public MinePayload(class_2846.class_2847 action, class_2338 pos, class_2350 direction) {
        this(action, pos, direction, 0);
    }

    private MinePayload(class_2540 buf) {
        super(buf.method_10818(class_2846.class_2847.class), buf.method_10811(), class_2350.method_10143(buf.readUnsignedByte()));
        this.action = buf.method_10818(class_2846.class_2847.class);
        this.pos = buf.method_10811();
        this.direction = class_2350.method_10143(buf.readUnsignedByte());
        this.sequence = buf.method_10816();
    }

    private void method_55988(class_2540 buf) {
        buf.method_10817(this.action);
        buf.method_10807(this.pos);
        buf.method_52997(this.direction.method_10146());
        buf.method_10804(this.sequence);
    }

    public Action getReal() {
        return switch (action) {
            case field_12968 -> Action.START_DESTROY_BLOCK;
            case field_12971 -> Action.ABORT_DESTROY_BLOCK;
            case field_12973 -> Action.STOP_DESTROY_BLOCK;
            default -> Action.NULL;
        };
    }

    public enum Action {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        NULL
    }

    public class_2338 method_12362() {
        return this.pos;
    }

    public class_2350 method_12360() {
        return this.direction;
    }

    public class_2846.class_2847 method_12363() {
        return this.action;
    }

    public int method_42079() {return this.sequence; }

}