package eva.dualwielding.mixin.client;

import eva.dualwielding.access.PlayerAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static eva.dualwielding.config.ConfigInterpreter.checkAttacker;

@Environment(EnvType.CLIENT)
@Mixin(class_329.class)
public abstract class InGameHudMixin {

    @Shadow @Final @Mutable private final class_310 client;

    @Unique private static final class_2960 CHI_FULL_TEXTURE = class_2960.method_60655("dualwielding", "hud/crosshair_attack_indicator_full");
    @Unique private static final class_2960 CHI_BACKGROUND_TEXTURE = class_2960.method_60655("dualwielding", "hud/crosshair_attack_indicator_background");
    @Unique private static final class_2960 CHI_PROGRESS_TEXTURE = class_2960.method_60655("dualwielding", "hud/crosshair_attack_indicator_progress");

    @Unique private static final class_2960 HAI_BACKGROUND_TEXTURE = class_2960.method_60655("dualwielding", "hud/hotbar_attack_indicator_background");
    @Unique private static final class_2960 HAI_PROGRESS_TEXTURE = class_2960.method_60655("dualwielding", "hud/hotbar_attack_indicator_progress");

    public InGameHudMixin(class_310 client) {
        this.client = client;
    }

    @Inject(method = "renderCrosshair", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getAttackCooldownProgress(F)F", shift = Shift.AFTER))
    private void renderCrosshairMixin(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        assert this.client.field_1724 != null;
        if (checkAttacker(this.client.field_1724.method_6079())) {
            float f = ((PlayerAccess) this.client.field_1724).dualWielding$getAttackCooldownProgress(0.0F);
            boolean bl = false;
            if (this.client.field_1692 != null && this.client.field_1692 instanceof class_1309 && f >= 1.0F) {
                bl = ((PlayerAccess) this.client.field_1724).dualWielding$getAttackCooldownProgressPerTick() > 5.0F;
                bl &= this.client.field_1692.method_5805();
            }

            int j = context.method_51443() / 2 - 10;
            int k = context.method_51421() / 2 - 8;
            if (bl) {
                context.method_52706(class_1921::method_62280, CHI_FULL_TEXTURE, k, j - 16, 16, 16);
            } else if (f < 1.0F) {
                int l = (int) (f * 17.0F);
                context.method_52706(class_1921::method_62280, CHI_BACKGROUND_TEXTURE, k, j - 4, 16, 4);
                context.method_52708(class_1921::method_62280, CHI_PROGRESS_TEXTURE, 16, 4, 17 - l, 0, k + 17 - l, j - 4, l, 4);
            }
        }
    }

    @Inject(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getAttackCooldownProgress(F)F", shift = Shift.AFTER))
    private void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        assert this.client.field_1724 != null;
        if (checkAttacker(this.client.field_1724.method_6079())) {
            float f = ((PlayerAccess) this.client.field_1724).dualWielding$getAttackCooldownProgress(0.0F);
            int i = context.method_51421() / 2;
            if (f < 1.0F) {
                int n = context.method_51443() - 20;
                int o = i + 91 + 6;
                if (this.client.field_1724.method_6068().method_5928() == class_1306.field_6183) {
                    o = i - 91 - 22;
                }

                int p = (int) (f * 19.0F);
                context.method_52706(class_1921::method_62277, HAI_BACKGROUND_TEXTURE, o, n, 18, 18);
                context.method_52708(class_1921::method_62277, HAI_PROGRESS_TEXTURE, 18, 18, 0, 18 - p, o, n + 18 - p, 18, p);
            }
        }
    }
}
