package eva.dualwielding.mixin.client;

import eva.dualwielding.access.PlayerAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_329.class)
public abstract class GuiMixin {

    @Shadow @Final @Mutable private final class_310 minecraft;

    @Unique private static final class_2960 CHI_FULL_TEXTURE = class_2960.method_43902("dualwielding", "hud/crosshair_attack_indicator_full");
    @Unique private static final class_2960 CHI_BACKGROUND_TEXTURE = class_2960.method_43902("dualwielding", "hud/crosshair_attack_indicator_background");
    @Unique private static final class_2960 CHI_PROGRESS_TEXTURE = class_2960.method_43902("dualwielding", "hud/crosshair_attack_indicator_progress");

    @Unique private static final class_2960 HAI_BACKGROUND_TEXTURE = class_2960.method_43902("dualwielding", "hud/hotbar_attack_indicator_background");
    @Unique private static final class_2960 HAI_PROGRESS_TEXTURE = class_2960.method_43902("dualwielding", "hud/hotbar_attack_indicator_progress");

    public GuiMixin(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    @Inject(method = "renderCrosshair", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F", shift = Shift.AFTER))
    private void renderCrosshairMixin(class_332 context, CallbackInfo ci) {
        assert this.minecraft.field_1724 != null;
        float f = ((PlayerAccess) this.minecraft.field_1724).dualWielding$getAttackStrengthScale(0.0F);
        boolean bl = false;
        if (this.minecraft.field_1692 != null && this.minecraft.field_1692 instanceof class_1309 && f >= 1.0F) {
            bl = ((PlayerAccess) this.minecraft.field_1724).dualWielding$getOffhandItemAttackStrengthDelay() > 5.0F;
            bl &= this.minecraft.field_1692.method_5805();
        }

        int j = context.method_51443() / 2 - 10;
        int k = context.method_51421() / 2 - 8;
        if (bl) {
            context.method_25302(CHI_FULL_TEXTURE, k, j - 16, 0, 0,16, 16);
        } else if (f < 1.0F) {
            int l = (int) (f * 17.0F);
            context.method_25302(CHI_BACKGROUND_TEXTURE, k, j - 4, 0, 0, 16, 4);
            context.method_25290(CHI_PROGRESS_TEXTURE, 16, 4, 0, 0, k + 17 - l, j - 4, l, 4);
        }
    }

    @Inject(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F", shift = Shift.AFTER))
    private void renderHotbar(float partialTick, class_332 context, CallbackInfo ci) {
        assert this.minecraft.field_1724 != null;
        float f = ((PlayerAccess) this.minecraft.field_1724).dualWielding$getAttackStrengthScale(0.0F);
        int i = context.method_51421() / 2;
        if (f < 1.0F) {
            int n = context.method_51443() - 20;
            int o = i + 91 + 6;
            if (this.minecraft.field_1724.method_6068().method_5928() == class_1306.field_6183) {
                o = i - 91 - 22;
            }

            int p = (int) (f * 19.0F);
            context.method_25302(HAI_BACKGROUND_TEXTURE, o, n, 0, 0, 18, 18);
            context.method_25302(HAI_PROGRESS_TEXTURE,  o, n + 18 - p, 0, 112 - p, 18, p);
        }
    }
}
