package eva.dualwielding.network;

import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import java.util.function.Function;


public record AttackPacket(int entityId) implements FabricPacket {

    public static final class_2960 ID = new class_2960("sdw", "off_attack");

    public static final PacketType<AttackPacket> TYPE = PacketType.create(ID, new Function<class_2540, AttackPacket>() {
        @Override
        public AttackPacket apply(class_2540 buf) {
            return new AttackPacket(buf.method_10816());
        }
    });

    public static class_2596<?> attackPacket(int entityId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(entityId);
        return ClientPlayNetworking.createC2SPacket(ID, buf);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(entityId);
    }

    @Override
    public PacketType<AttackPacket> getType() {
        return TYPE;
    }
}