package eva.dualwielding.mixin;

import eva.dualwielding.DualWieldingMain;
import eva.dualwielding.access.BlockAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.access.ServerManagerAccess;
import eva.dualwielding.network.MinePayload;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_5552;

@Mixin(class_3225.class)
public class ServerPlayerInteractionManagerMixin implements ServerManagerAccess {
    
    @Final @Shadow protected class_3222 player;
    @Shadow protected class_3218 world;
    @Shadow private class_1934 gameMode;
    @Shadow private int failedStartMiningTime;
    @Shadow private int startMiningTime;
    @Shadow private boolean failedToMine;
    @Shadow private class_2338 failedMiningPos;
    @Shadow private class_2338 miningPos;
    @Shadow private int blockBreakingProgress;
    @Shadow private boolean mining;

    @Shadow private int tickCounter;
    @Unique private int useTickCounter() {
        return tickCounter + 1;
    }

    @Inject(method = "update", at = @At(value = "HEAD"))
    public void doUpdate(CallbackInfo ci) {
        if (this.failedToMine) {
            class_2680 blockState = this.world.method_8320(this.failedMiningPos);
            if (blockState.method_26215()) {
                this.failedToMine = false;
            } else {
                float f = this.dualWielding$continueMining(blockState, this.failedMiningPos, this.failedStartMiningTime);
                if (f >= 1.0F) {
                    this.failedToMine = false;
                    this.dualWielding$tryBreakBlock(this.failedMiningPos);
                }
            }
        } else if (this.mining) {
            class_2680 blockState = this.world.method_8320(this.miningPos);
            if (blockState.method_26215()) {
                this.world.method_8517(this.player.method_5628(), this.miningPos, -1);
                this.blockBreakingProgress = -1;
                this.mining = false;
            } else {
                this.dualWielding$continueMining(blockState, this.miningPos, this.startMiningTime);
            }
        }
    }

    @Unique
    public void dualWielding$processBlockBreakingAction(class_2338 pos, MinePayload.Action action, class_2350 direction, int worldHeight, int sequence) {
        if (!this.player.method_56093(pos, 1.0)) {
            this.dualWielding$onBlockBreakingAction(pos, false, sequence, "too far");
        } else if (pos.method_10264() > worldHeight) {
            this.player.field_13987.method_14364(new class_2626(pos, this.world.method_8320(pos)));
            this.dualWielding$onBlockBreakingAction(pos, false, sequence, "too high");
        } else {
            if (action == MinePayload.Action.START_DESTROY_BLOCK) {
                if (!this.world.method_8505(this.player, pos)) {
                    this.player.field_13987.method_14364(new class_2626(pos, this.world.method_8320(pos)));
                    this.dualWielding$onBlockBreakingAction(pos, false, sequence, "may not interact");
                    return;
                }

                if (((class_3225) (Object) this).method_14268()) {
                    this.dualWielding$finishMining(pos, sequence, "creative destroy");
                    return;
                }

                if (this.player.method_21701(this.world, pos, this.gameMode)) {
                    this.player.field_13987.method_14364(new class_2626(pos, this.world.method_8320(pos)));
                    this.dualWielding$onBlockBreakingAction(pos, false, sequence, "block action restricted");
                    return;
                }

                this.startMiningTime = this.tickCounter;
                float f = 1.0F;
                class_2680 blockState = this.world.method_8320(pos);
                if (!blockState.method_26215()) {
                    class_1890.method_60124(this.world, this.player.method_6079(), this.player, this.player, class_1304.field_6171, class_243.method_24953(pos), blockState, (item) -> this.player.method_20235(item, class_1304.field_6171));
                    blockState.method_26179(this.world, pos, this.player);
                    f = ((BlockAccess)blockState).dualWielding$calcBlockBreakingDelta(this.player, this.player.method_37908(), pos);
                }

                if (!blockState.method_26215() && f >= 1.0F) {
                    this.dualWielding$finishMining(pos, sequence, "insta mine");
                } else {
                    if (this.mining) {
                        this.player.field_13987.method_14364(new class_2626(this.miningPos, this.world.method_8320(this.miningPos)));
                        this.dualWielding$onBlockBreakingAction(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                    }

                    this.mining = true;
                    this.miningPos = pos.method_10062();
                    int i = (int)(f * 10.0F);
                    this.world.method_8517(this.player.method_5628(), pos, i);
                    this.dualWielding$onBlockBreakingAction(pos, true, sequence, "actual start of destroying");
                    this.blockBreakingProgress = i;
                }
            } else if (action == MinePayload.Action.STOP_DESTROY_BLOCK) {
                if (pos.equals(this.miningPos)) {
                    int j = this.tickCounter - this.startMiningTime;
                    class_2680 blockState = this.world.method_8320(pos);
                    if (!blockState.method_26215()) {
                        float g = ((BlockAccess)blockState).dualWielding$calcBlockBreakingDelta(this.player, this.player.method_37908(), pos) * (float)(j + 1);
                        if (g >= 0.7F) {
                            this.mining = false;
                            this.world.method_8517(this.player.method_5628(), pos, -1);
                            this.dualWielding$finishMining(pos, sequence, "destroyed");
                            return;
                        }

                        if (!this.failedToMine) {
                            this.mining = false;
                            this.failedToMine = true;
                            this.failedMiningPos = pos;
                            this.failedStartMiningTime = this.startMiningTime;
                        }
                    }
                }

                this.dualWielding$onBlockBreakingAction(pos, true, sequence, "stopped destroying");
            } else if (action == MinePayload.Action.ABORT_DESTROY_BLOCK) {
                this.mining = false;
                if (!Objects.equals(this.miningPos, pos)) {
                    DualWieldingMain.LOGGER.warn("Mismatch in destroy block pos: {} {}", this.miningPos, pos);
                    this.world.method_8517(this.player.method_5628(), this.miningPos, -1);
                    this.dualWielding$onBlockBreakingAction(pos, true, sequence, "aborted mismatched destroying");
                }

                this.world.method_8517(this.player.method_5628(), pos, -1);
                this.dualWielding$onBlockBreakingAction(pos, true, sequence, "aborted destroying");
            }

        }
    }

    @Unique
    public float dualWielding$continueMining(class_2680 state, class_2338 pos, int failedStartMiningTime) {
        int i = useTickCounter() - failedStartMiningTime;
        float f = ((BlockAccess)state).dualWielding$calcBlockBreakingDelta(this.player, this.player.method_37908(), pos) * (float)(i + 1);
        int j = (int)(f * 10.0F);
        if (j != this.blockBreakingProgress) {
            this.world.method_8517(this.player.method_5628(), pos, j);
            this.blockBreakingProgress = j;
        }

        return f;
    }

    @Unique
    public void dualWielding$finishMining(class_2338 pos, int sequence, String reason) {
        if (this.dualWielding$tryBreakBlock(pos)) {
            this.dualWielding$onBlockBreakingAction(pos, true, sequence, reason);
        } else {
            player.field_13987.method_14364(new class_2626(pos, world.method_8320(pos)));
            this.dualWielding$onBlockBreakingAction(pos, false, sequence, reason);
        }

    }

    @Unique
    public boolean dualWielding$tryBreakBlock(class_2338 pos) {
        class_2680 blockState = this.world.method_8320(pos);
        if (!this.player.method_6079().method_7909().method_7885(blockState, this.world, pos, this.player)) {
            return false;
        } else {
            class_2586 blockEntity = this.world.method_8321(pos);
            class_2248 block = blockState.method_26204();
            if (block instanceof class_5552 && !this.player.method_7338()) {
                this.world.method_8413(pos, blockState, blockState, 3);
                return false;
            } else if (this.player.method_21701(this.world, pos, this.gameMode)) {
                return false;
            } else {
                class_2680 blockState2 = block.method_9576(this.world, pos, blockState, this.player);
                boolean bl = this.world.method_8650(pos, false);
                if (bl) {
                    block.method_9585(this.world, pos, blockState2);
                }

                if (!((class_3225) (Object) this).method_14268()) {
                    class_1799 itemStack = this.player.method_6079();
                    class_1799 itemStack2 = itemStack.method_7972();
                    boolean bl2 = ((PlayerAccess)this.player).dualWielding$canHarvest(blockState2);
                    itemStack.method_7952(this.world, blockState2, pos, this.player);
                    if (bl && bl2) {
                        block.method_9556(this.world, this.player, pos, blockState2, blockEntity, itemStack2);
                    }

                }
                return true;
            }
        }
    }

    @Shadow(prefix = "dualWielding$")
    private void dualWielding$onBlockBreakingAction(class_2338 pos, boolean success, int sequence, String reason) {}

}
