package eva.dualwielding.config;

import com.bejker.interactionmanager.Interactions;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import static eva.dualwielding.DualWieldingClient.iMLoaded;
import static eva.dualwielding.config.SimplyDualWieldingConfig.*;

public class ConfigInterpreter {

    private static final boolean[] empty = new boolean[2];
    private static final ItemCat[] attack = new ItemCat[2];
    private static final ItemCat[] mine = new ItemCat[2];
    private static final Set<?>[] attacksSet = new Set[2];
    private static final Set<?>[] minesSet = new Set[2];
    private static boolean rAttacks = true;
    private static boolean rMines = true;
    private static final SimplyDualWieldingConfig[] INSTANCE = {getServerInstance(), getInstance()};
    private static Boolean server;
    private static final boolean[] allowWeak = getInstance().getAllowWeakConfig();

    public static boolean checkEmpty(class_1799 stack) {
        int w = 0;
        if (!getReadStatus(w) && (allowWeak[w] || !checkServer()))
            empty[1] = INSTANCE[1].getEmpty();
        if (stack.method_7960()) {
            if (!checkServer() || empty[0] && allowWeak[w])
                return empty[1];
            return empty[0];
        }
        return false;
    }

    public static boolean checkAttacker(class_1799 stack) {
        if (stack.method_7960()) return false;
        int w = 1;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        if (!getReadStatus(w) && (allowWeak[w] || !checkServer()))
            attack[1] = INSTANCE[1].getAttacks();
        for (int lim = (checkServer() && !allowWeak[0]) ? 1 : 2; i < lim; i++) {
            comp[i] = switch (attack[i]) {
                case ALL -> true;
                case TOOLS -> stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS);
                case WEAPONS -> stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case TOOLS_AND_WEAPONS ->
                        stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS) || stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case NONE -> false;
                case BLACKLIST -> !checkList(w, stack.method_7909());
                case WHITELIST -> checkList(w, stack.method_7909());
                case null -> false;
            };
        }
        if (!checkServer() || comp[0] && allowWeak[w])
            return comp[1];
        return comp[0];
    }

    public static boolean checkMiner(class_1799 stack) {
        if (stack.method_7960()) return false;
        int w = 2;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        if (!getReadStatus(w) && (allowWeak[w] || !checkServer()))
            mine[i] = INSTANCE[i].getMines();
        for (int lim = (checkServer() && !allowWeak[0]) ? 1 : 2; i < lim; i++) {
            comp[i] = switch (mine[i]) {
                case ALL -> true;
                case TOOLS -> stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS);
                case WEAPONS -> stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case TOOLS_AND_WEAPONS ->
                        stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS) || stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case NONE -> false;
                case BLACKLIST -> !checkList(w, stack.method_7909());
                case WHITELIST -> checkList(w, stack.method_7909());
                case null -> false;
            };
        }
        if (!checkServer() || comp[0] && allowWeak[w])
            return comp[1];
        return comp[0];
    }

    public static boolean checkRA(class_1657 pe, class_1297 target) {
        if (!iMLoaded) return false;
        if (!getReadStatus(5)) rAttacks = INSTANCE[1].getRespectIMAttacking();
        if (rAttacks) {
            CallbackInfo ci = new CallbackInfo("dummy", true);
            Interactions.onAttackEntity(pe.method_5667(), target, ci);
            return ci.isCancelled();
        }
        return false;
    }

    public static boolean checkRM(class_2248 block) {
        if (!iMLoaded) return false;
        if (!getReadStatus(6)) rMines = INSTANCE[1].getRespectIMMining();
        if (rMines) {
            CallbackInfoReturnable<Boolean> cir = new CallbackInfoReturnable<>("dummy", true, false);
            Interactions.restrictBlockBreaking(block, cir);
            return cir.getReturnValueZ();
        }
        return false;
    }

    private static boolean checkList(int w, class_1792 item) {
        w += 2;
        int i = 1;
        Set<?> set = switch (w) {
            case 3 -> {
                if (!getReadStatus(w)) attacksSet[i] = getSetFromList(INSTANCE[i].getAttackItems());
                yield attacksSet[i];
            }
            case 4 -> {
                if (!getReadStatus(w)) minesSet[i] = getSetFromList(INSTANCE[i].getMineItems());
                yield minesSet[i];
            }
            default -> ConcurrentHashMap.newKeySet();
        };
        return set.contains(class_7923.field_41178.method_10221(item));
    }

    private static boolean checkServer() {
        if (server == null)
            server = INSTANCE[0] != null;
        return server;
    }
}
