/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding.config;

import eva.dualwielding.config.ItemCat;
import eva.dualwielding.network.ConfigPayload;
import eva.dualwielding.network.ListPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SimplyDualWieldingConfig {
    private boolean empty = false;
    private ItemCat attacks = ItemCat.ALL;
    private ItemCat mines = ItemCat.ALL;
    private List<String> attackList = new ArrayList<String>();
    private List<String> mineList = new ArrayList<String>();
    private boolean[] allowWeakConfig = new boolean[]{false, false, false};
    private boolean respectIMMining = true;
    private boolean respectIMAttacking = true;
    private static SimplyDualWieldingConfig INSTANCE;
    private static SimplyDualWieldingConfig SERVER_INSTANCE;
    private static final boolean[] readSinceLastUpdate;
    private static final List<String> def;
    private static ListState listState;

    private SimplyDualWieldingConfig() {
    }

    public SimplyDualWieldingConfig(boolean empty, ItemCat attacks, ItemCat mines, boolean[] allowWeakConfig) {
        this.empty = empty;
        this.attacks = attacks;
        this.mines = mines;
        this.allowWeakConfig = allowWeakConfig;
    }

    public static SimplyDualWieldingConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimplyDualWieldingConfig();
        }
        return INSTANCE;
    }

    public static SimplyDualWieldingConfig getServerInstance() {
        return SERVER_INSTANCE;
    }

    private static void setServerInstance(SimplyDualWieldingConfig newInstance) {
        SERVER_INSTANCE = newInstance;
    }

    public void updateConfigs(SimplyDualWieldingConfig config) {
        this.empty = config.empty;
        this.attacks = config.attacks;
        this.mines = config.mines;
        SimplyDualWieldingConfig.setAttackItems(config.attackList);
        SimplyDualWieldingConfig.setMineItems(config.mineList);
    }

    static void setEmpty(boolean setter) {
        SimplyDualWieldingConfig.readSinceLastUpdate[0] = false;
        SimplyDualWieldingConfig.getInstance().empty = setter;
    }

    public boolean getEmpty() {
        SimplyDualWieldingConfig.readSinceLastUpdate[0] = true;
        return this.empty;
    }

    static void setAttacks(ItemCat setter) {
        SimplyDualWieldingConfig.readSinceLastUpdate[1] = false;
        SimplyDualWieldingConfig.getInstance().attacks = setter;
    }

    public ItemCat getAttacks() {
        SimplyDualWieldingConfig.readSinceLastUpdate[1] = true;
        return this.attacks;
    }

    static void setMines(ItemCat setter) {
        SimplyDualWieldingConfig.readSinceLastUpdate[2] = false;
        SimplyDualWieldingConfig.getInstance().mines = setter;
    }

    public ItemCat getMines() {
        SimplyDualWieldingConfig.readSinceLastUpdate[2] = true;
        return this.mines;
    }

    public List<String> getAttackItems() {
        SimplyDualWieldingConfig.readSinceLastUpdate[3] = true;
        return this.attackList;
    }

    static void setAttackItems(List<String> newList) {
        SimplyDualWieldingConfig.readSinceLastUpdate[3] = false;
        SimplyDualWieldingConfig.getInstance().attackList = newList;
    }

    public List<String> getMineItems() {
        SimplyDualWieldingConfig.readSinceLastUpdate[4] = true;
        return this.mineList;
    }

    static void setMineItems(List<String> newList) {
        SimplyDualWieldingConfig.readSinceLastUpdate[4] = false;
        SimplyDualWieldingConfig.getInstance().mineList = newList;
    }

    public boolean getRespectIMAttacking() {
        SimplyDualWieldingConfig.readSinceLastUpdate[5] = true;
        return this.respectIMAttacking;
    }

    static void setRespectIMAttacking(boolean newVal) {
        SimplyDualWieldingConfig.readSinceLastUpdate[5] = false;
        SimplyDualWieldingConfig.getInstance().respectIMAttacking = newVal;
    }

    public boolean getRespectIMMining() {
        SimplyDualWieldingConfig.readSinceLastUpdate[6] = true;
        return this.respectIMMining;
    }

    static void setRespectIMMining(boolean newVal) {
        SimplyDualWieldingConfig.readSinceLastUpdate[6] = false;
        SimplyDualWieldingConfig.getInstance().respectIMMining = newVal;
    }

    public static Set<class_2960> getSetFromList(List<String> list) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        for (String nam : list) {
            set.add(class_2960.method_60654((String)nam));
        }
        return set;
    }

    public static boolean getReadStatus(int i) {
        return readSinceLastUpdate[i];
    }

    public static void onConfigReceived(ConfigPayload payload) {
        SimplyDualWieldingConfig.setServerInstance(payload.getHeldInstance());
    }

    public static void onListReceived(ListPayload listPayload) {
        List<String> list = listPayload.getList();
        for (String entry : list) {
            switch (listState.ordinal()) {
                case 0: {
                    if (entry.isEmpty()) {
                        listState = ListState.MINE;
                        break;
                    }
                    SimplyDualWieldingConfig.SERVER_INSTANCE.attackList.add(entry);
                    break;
                }
                case 1: {
                    if (entry.isEmpty()) {
                        listState = ListState.ATTACK;
                        break;
                    }
                    SimplyDualWieldingConfig.SERVER_INSTANCE.mineList.add(entry);
                }
            }
        }
    }

    static Function<String, Optional<class_2561>> getErrorSupplier() {
        return new ErrorSupplier();
    }

    static List<String> getDef() {
        return def;
    }

    public boolean[] getAllowWeakConfig() {
        return this.allowWeakConfig;
    }

    public boolean getAllowWeakConfig(int i) {
        return this.allowWeakConfig[i];
    }

    public static void disconnect() {
        if (SERVER_INSTANCE != null) {
            SERVER_INSTANCE = null;
        }
    }

    static {
        readSinceLastUpdate = new boolean[]{false, false, false, false, false, false, false};
        def = new ArrayList<String>();
        def.add("minecraft:air");
        listState = ListState.ATTACK;
    }

    private static enum ListState {
        ATTACK,
        MINE;

    }

    private static class ErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private ErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(58) != entry.lastIndexOf(58)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item ID! error code: 1"));
            }
            String name = entry.substring(entry.indexOf(58) + 1).replaceAll("[^a-z0-9/._-]", "");
            if (!entry.equals(name)) {
                if (entry.indexOf(58) == -1) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item ID! error code: 2"));
                }
                String namespace = entry.substring(0, entry.indexOf(58)).replaceAll("[^a-z0-9/._-]", "");
                if (!entry.equals(namespace + ":" + name)) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item ID! error code: 3"));
                }
            }
            class_2960 id = class_2960.method_60654((String)entry);
            if (!class_7923.field_41178.method_10235().contains(id)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item ID! error code: 4"));
            }
            return Optional.empty();
        }
    }
}

