/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding.config;

import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.config.enums.ConditionalBehavior;
import eva.dualwielding.config.enums.Handy;
import eva.dualwielding.config.enums.ItemCat;
import java.lang.runtime.SwitchBootstraps;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class ConfigInterpreter {
    private static final SimplyDualWieldingConfig[] INSTANCE;
    private static Boolean server;
    private static final boolean[] allowWeak;
    private static boolean[] handy;

    public static boolean checkEmpty(class_1799 stack) {
        if (stack.method_7960()) {
            if (!ConfigInterpreter.checkServer() || INSTANCE[0].getEmpty() && allowWeak[0]) {
                return INSTANCE[1].getEmpty();
            }
            return INSTANCE[0].getEmpty();
        }
        return false;
    }

    public static boolean checkAttacker(class_1799 stack) {
        return ConfigInterpreter.checker(stack, 0);
    }

    public static boolean checkMiner(class_1799 stack) {
        return ConfigInterpreter.checker(stack, 1);
    }

    private static boolean checker(class_1799 stack, int ind) {
        int lim;
        if (stack.method_7960()) {
            return false;
        }
        int i = 1;
        boolean[] comp = new boolean[]{false, false};
        if (ConfigInterpreter.checkServer()) {
            i = 0;
        }
        int n = lim = ConfigInterpreter.checkServer() && !allowWeak[ind] ? 1 : 2;
        while (i < lim) {
            ItemCat[] cat = new ItemCat[]{INSTANCE[i].getAttacks(), INSTANCE[i].getMines()};
            ItemCat itemCat = cat[ind];
            int n2 = 0;
            comp[i] = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ALL", "TOOLS", "WEAPONS", "TOOLS_AND_WEAPONS", "NONE", "BLACKLIST", "WHITELIST"}, (ItemCat)itemCat, n2)) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> {
                    if (stack.method_31573(ConventionalItemTags.MINING_TOOLS) || stack.method_31573(class_3489.field_42612)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> stack.method_31573(ConventionalItemTags.MELEE_WEAPONS_TOOLS);
                case 3 -> {
                    if (stack.method_31573(ConventionalItemTags.MINING_TOOLS) || stack.method_31573(ConventionalItemTags.MELEE_WEAPONS_TOOLS)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> false;
                case 5 -> {
                    if (!ConfigInterpreter.checkList(ind, i, stack.method_7909())) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> ConfigInterpreter.checkList(ind, i, stack.method_7909());
                case -1 -> false;
            };
            ++i;
        }
        if (!ConfigInterpreter.checkServer() || comp[0] && allowWeak[ind]) {
            return comp[1];
        }
        return comp[0];
    }

    public static boolean checkUseRestricted(class_1799 stack, boolean sneaking) {
        int lim;
        if (stack.method_7960()) {
            return false;
        }
        int i = 1;
        boolean[] comp = new boolean[]{false, false};
        if (ConfigInterpreter.checkServer()) {
            i = 0;
        }
        int n = lim = ConfigInterpreter.checkServer() && INSTANCE[0].getAllowWeakConfig(3) ? 1 : 2;
        while (i < lim) {
            comp[i] = switch (INSTANCE[i].getRestrictUse()) {
                default -> throw new MatchException(null, null);
                case ConditionalBehavior.ALWAYS -> ConfigInterpreter.checkList(2, i, stack.method_7909());
                case ConditionalBehavior.SNEAKING_ONLY -> {
                    if (sneaking && ConfigInterpreter.checkList(2, i, stack.method_7909())) {
                        yield true;
                    }
                    yield false;
                }
                case ConditionalBehavior.NOT_SNEAKING -> {
                    if (!sneaking && ConfigInterpreter.checkList(2, i, stack.method_7909())) {
                        yield true;
                    }
                    yield false;
                }
                case ConditionalBehavior.NEVER -> false;
            };
            ++i;
        }
        if (!ConfigInterpreter.checkServer() || !comp[0] && INSTANCE[0].getAllowWeakConfig(3)) {
            return comp[1];
        }
        return comp[0];
    }

    private static boolean checkList(int w, int i, class_1792 item) {
        ConcurrentHashMap.KeySetView set = switch (w) {
            case 0 -> SimplyDualWieldingConfig.getSetFromList(INSTANCE[i].getAttackItems());
            case 1 -> SimplyDualWieldingConfig.getSetFromList(INSTANCE[i].getMineItems());
            case 2 -> SimplyDualWieldingConfig.getSetFromList(INSTANCE[i].getDisableUseItems());
            default -> ConcurrentHashMap.newKeySet();
        };
        return set.contains(class_7923.field_41178.method_10221((Object)item));
    }

    private static boolean checkServer() {
        if (server == null) {
            server = INSTANCE[0] != null;
        }
        return server;
    }

    public static float modifyDamage(float damage, class_1657 player) {
        double[] dArray;
        Handy handed;
        class_1268 hand;
        boolean bl = ((LivingEntityAccess)player).offhand(false);
        class_1268 class_12682 = hand = bl ? class_1268.field_5810 : class_1268.field_5808;
        if (player.method_5998(hand).method_7960()) {
            ((LivingEntityAccess)player).offhand(bl);
            return damage;
        }
        int i = 1;
        if (ConfigInterpreter.checkServer()) {
            i = 0;
        }
        if (handy[0] || handy[1]) {
            handed = handy[0] && handy[1] ? Handy.DUAL : (player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_7960() ? Handy.TWO_HAND : Handy.ONE_HAND);
        } else {
            ((LivingEntityAccess)player).offhand(bl);
            return damage;
        }
        switch (INSTANCE[i].getMode()) {
            case PRETTY_MUCH_BALANCED: {
                double[] dArray2 = new double[3];
                dArray2[0] = 0.8;
                dArray2[1] = 1.0;
                dArray = dArray2;
                dArray2[2] = 1.2;
                break;
            }
            case CUSTOM_BALANCE: {
                dArray = INSTANCE[i].getValues();
                break;
            }
            default: {
                double[] dArray3 = new double[3];
                dArray3[0] = 1.0;
                dArray3[1] = 1.0;
                dArray = dArray3;
                dArray3[2] = 1.0;
            }
        }
        double[] vals = dArray;
        ((LivingEntityAccess)player).offhand(bl);
        return damage *= (float)vals[handed.ordinal()];
    }

    public static float modifyASpd(float refreshRate, class_1657 player, class_1268 hand) {
        double[] dArray;
        Handy handed;
        if (player.method_5998(hand).method_7960()) {
            return refreshRate;
        }
        int i = 1;
        if (ConfigInterpreter.checkServer()) {
            i = 0;
        }
        if (handy[0] || handy[1]) {
            handed = handy[0] && handy[1] ? Handy.DUAL : (player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_7960() ? Handy.TWO_HAND : Handy.ONE_HAND);
        } else {
            return refreshRate;
        }
        switch (INSTANCE[i].getMode()) {
            case PRETTY_MUCH_BALANCED: {
                double[] dArray2 = new double[3];
                dArray2[0] = 0.8;
                dArray2[1] = 1.0;
                dArray = dArray2;
                dArray2[2] = 1.2;
                break;
            }
            case CUSTOM_BALANCE: {
                dArray = INSTANCE[i].getValues();
                break;
            }
            default: {
                double[] dArray3 = new double[3];
                dArray3[0] = 1.0;
                dArray3[1] = 1.0;
                dArray = dArray3;
                dArray3[2] = 1.0;
            }
        }
        double[] vals = dArray;
        return refreshRate /= (float)vals[(handed.ordinal() + 3) % vals.length];
    }

    public static void handFixer(class_1657 player) {
        handy = new boolean[]{false, false};
        int[] j = new int[]{0};
        while (j[0] < 2) {
            try {
                player.method_5998(class_1268.values()[j[0]]).method_57354(class_1304.field_6173, (attribute, modifier) -> {
                    if (attribute == class_5134.field_23721) {
                        ConfigInterpreter.handy[j[0]] = true;
                    }
                });
            }
            catch (NullPointerException exception) {
                ConfigInterpreter.handy[j[0]] = false;
            }
            j[0] = j[0] + 1;
        }
    }

    static {
        boolean[] blArray;
        INSTANCE = new SimplyDualWieldingConfig[]{SimplyDualWieldingConfig.getServerInstance(), SimplyDualWieldingConfig.getInstance()};
        if (SimplyDualWieldingConfig.getServerInstance() != null) {
            blArray = SimplyDualWieldingConfig.getServerInstance().getAllowWeakConfig();
        } else {
            boolean[] blArray2 = new boolean[4];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray2[2] = true;
            blArray = blArray2;
            blArray2[3] = true;
        }
        allowWeak = blArray;
        handy = new boolean[]{false, false};
    }
}

