package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.access.MultiPlayerGameModeAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.network.AttackPayload;
import eva.dualwielding.util.IsMining;
import eva.dualwielding.util.LastAct;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.dualwielding.config.ConfigInterpreter.*;

@Environment(EnvType.CLIENT)
@Mixin(class_310.class)
public class MinecraftMixin {

    @Shadow @Nullable public class_746 player;
    @Shadow @Nullable public class_636 gameMode;
    @Shadow @Nullable public class_638 level;

    @Unique private int secondAttackCooldown;

    @Unique private boolean held = false;
    @Unique private LastAct noSwap = LastAct.NULL;
    @Unique private IsMining isMining = IsMining.NULL;
    @Unique private final class_310 tMc = (class_310) (Object) this;

    @Unique private boolean breaki = false;

    @Unique private boolean[] bl;

    @Inject(method = "startUseItem", at = @At("RETURN"))
    private void spamFixer(CallbackInfo ci) {held = false;}

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;handleKeybinds()V"))
    public void tickTickTick(CallbackInfo ci) {
        if (this.secondAttackCooldown > 0) {
            --this.secondAttackCooldown;
        }
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/InteractionResult$Success;swingSource()Lnet/minecraft/world/InteractionResult$SwingSource;"
            )
    )
    private void set(CallbackInfo ci) {
        noSwap = LastAct.USE;
    }

    @Inject(method = "startUseItem", at = @At("HEAD"), cancellable = true)
    private void keepMining(CallbackInfo ci) {
        if (noSwap == LastAct.ATTACK && held) {
            this.breaki = this.doUseHit(ci, class_1268.field_5810, new class_1269.class_9859(), true);
        }
    }

    @Inject(method = "startUseItem",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"),
            cancellable = true)
    private void blockItemUseAction(CallbackInfo ci, @Local class_1268 hand) {
        assert player != null;
        if (hand == class_1268.field_5810 && checkUseRestricted(player.method_6079(), player.method_18276())) {
            this.breaki = this.doUseHit(ci, class_1268.field_5810, new class_1269.class_9859(), true);
        }
    }

    @Inject(
            method = "startUseItem",
            at = @At(
                    value = "RETURN",
                    shift = At.Shift.BY,
                    by = 2
            ),
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z",
                            ordinal = 1
                    )
            ),
            cancellable = true
    )
    private void doUseHit(CallbackInfo ci, @Local class_1268 hand) {
        assert this.gameMode != null;
        assert player != null;
        if (hand == class_1268.field_5810)
            this.breaki = this.doUseHit(ci, hand, new class_1269.class_9859(), false);
        else
            this.noSwap = LastAct.NULL;
    }

    @Unique
    private boolean doUseHit(CallbackInfo ci, class_1268 hand, class_1269 actRes, boolean skippedTo) {
        assert player != null;
        this.breaki = false;
        class_1799 stack = player.method_6079();
        this.bl = new boolean[]{checkEmpty(stack), checkMiner(stack), checkAttacker(stack)};
        boolean bl2 = false;
        if (bl[0] || !(!bl[1] && !bl[2]))
            if (!(!skippedTo && (hand != class_1268.field_5810 || (noSwap == LastAct.USE && !held))))
                if (actRes instanceof class_1269.class_9857 || actRes instanceof class_1269.class_9859) {
                    if (!player.method_7325()) {
                        // everything above this should remain in some form
                        boolean varHolder = this.isOffhand();
                        ((LivingEntityAccess) player).offhand(true);
                        bl2 = tMc.method_1536();
                        ((LivingEntityAccess) player).offhand(varHolder);
                    }
                }
        this.bl = null;
        ci.cancel();
        return bl2;
    }

    @ModifyExpressionValue(
            method = "startAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    opcode = Opcodes.GETFIELD
            )
    )
    private int missTimeCheck(int original) {
        if (this.isOffhand()) return this.secondAttackCooldown;
        return original;
    }

    @Redirect(
            method = "startAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    opcode = Opcodes.PUTFIELD
            )
    )
    private void missTimeSet(class_310 mc, int original) {
        if (this.isOffhand()) secondAttackCooldown = original;
        else mc.field_1771 = original;
    }

    @ModifyExpressionValue(
            method = "startAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/InteractionHand;MAIN_HAND:Lnet/minecraft/world/InteractionHand;"
            )
    )
    private class_1268 handReplacer(class_1268 original) {
        if (this.isOffhand()) return class_1268.field_5810;
        return original;
    }

    @Inject(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;",
                    shift = At.Shift.BEFORE
            )
    )
    private void noSwapper(CallbackInfoReturnable<Boolean> cir) {
        if (this.isOffhand()) this.noSwap = LastAct.ATTACK;
    }

    @Redirect(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;attack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)V"
            )
    )
    private void attack(class_636 gameMode, class_1657 player, class_1297 targetEntity) {
        if (this.isOffhand()) {
            if (!held && (bl[0] || bl[2])) {
                // Client
                ((PlayerAccess) player).dualWielding$attackOffhand(targetEntity);
                // Server
                ClientPlayNetworking.send(new AttackPayload(targetEntity.method_5628()));
            }
        }
        else gameMode.method_2918(player, targetEntity);
    }

    @ModifyExpressionValue(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/state/BlockState;isAir()Z",
                    ordinal = 0
            )
    )
    private boolean boolFiller(boolean original) {
        if (this.isOffhand()) {
            assert player != null;
            if (original) return true;
            return !(bl[0] || bl[1]);
        }
        return original;
    }

    @Inject(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;"
            ),
            cancellable = true
    )
    private void cancelIfCreative(CallbackInfoReturnable<Boolean> cir) {
        if (this.isOffhand()) {
            assert player != null;
            if (player.method_7337()) {
                cir.cancel();
            }
        }
    }

    @Redirect(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"
            )
    )
    private boolean blockDestroyStarter(class_636 gameMode, class_2338 blockPos, class_2350 face) {
        if (this.isOffhand()) {
            if (!held)
                return ((MultiPlayerGameModeAccess) gameMode).dualWielding$startDestroyBlock(blockPos, face);
            else {
                assert level != null;
                if (level.method_8320(blockPos).method_26215())
                    breaki = true;
                return true;
            }
        }
        return gameMode.method_2910(blockPos, face);
    }

//    @Redirect(
//            method = "startAttack",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/client/player/LocalPlayer;resetAttackStrengthTicker()V"
//            )
//    )
//    private void attackStrengthResetter(LocalPlayer player) {
//        if (this.isOffhand())
//            ((PlayerAccess) player).dualWielding$resetAttackStrengthTicker();
//        else
//            player.resetAttackStrengthTicker();
//    }

    @Inject(
            method = "startAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V"
            )
    )
    private void notHolding(CallbackInfoReturnable<Boolean> cir) {
        if (this.isOffhand()) held = false;
    }

    @Inject(method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/Minecraft;startUseItem()V",
                    ordinal = 1
            )
    )
    private void noHolding(CallbackInfo ci){
        held = true;
    }

    @Inject(method = "continueAttack", at = @At(value = "HEAD"), cancellable = true)
    private void stopSimulMine(CallbackInfo ci) {
        if (isMining == IsMining.OFF) {
            isMining = IsMining.NULL;
            ci.cancel();
        }
    }

    @Inject(method = "continueAttack",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;"))
    private void setMiningMain(CallbackInfo ci) {
        isMining = IsMining.MAIN;
    }

    @Inject(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/Minecraft;continueAttack(Z)V"
            )
    )
    private void handleBlockBreaking(CallbackInfo ci) {
        if (isMining == IsMining.MAIN)
            isMining = IsMining.NULL;
        else if (noSwap != LastAct.USE)
            offHandMine(tMc.field_1755 == null && !breaki && tMc.field_1690.field_1904.method_1434() && tMc.field_1729.method_1613());
    }

    @Unique
    private void offHandMine(boolean breaking) {
        assert player != null;
        if (checkEmpty(player.method_6079()) || checkMiner(player.method_6079())) {
            if (!player.method_7337()) {
                boolean varHolder = this.isOffhand();
                ((LivingEntityAccess) player).offhand(true);
                tMc.method_1590(breaking);
                ((LivingEntityAccess) player).offhand(varHolder);            }
        }
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    ordinal = 0
            )
    )
    private void missTimeSET(class_310 instance, int value) {
        if (this.isOffhand()) secondAttackCooldown = value;
        else instance.field_1771 = value;
    }

    @ModifyExpressionValue(
            method = "continueAttack",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;missTime:I",
                    ordinal = 1
            )
    )
    private int missTimeGET(int original) {
        if (this.isOffhand()) return secondAttackCooldown;
        return original;
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;continueDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"
            )
    )
    private boolean executeContinueDestroyBlock(class_636 instance, class_2338 posBlock, class_2350 directionFacing) {
        if (this.isOffhand()) return ((MultiPlayerGameModeAccess) instance).dualWielding$continueDestroyBlock(posBlock, directionFacing);
        return instance.method_2902(posBlock, directionFacing);
    }

    @ModifyArg(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V"
            )
    )
    private class_1268 replaceMainHandArg(class_1268 hand) {
        if (this.isOffhand()) return class_1268.field_5810;
        return hand;
    }

    @Redirect(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;stopDestroyBlock()V"
            )
    )
    private void stopDestroyBlock(class_636 instance) {
        if (this.isOffhand()) ((MultiPlayerGameModeAccess) instance).dualWielding$stopDestroyBlock();
        else instance.method_2925();
    }
    
    @Unique
    private boolean isOffhand() {
        assert player != null;
        return ((LivingEntityAccess) player).isOffhand();
    }
    
}