package eva.dualwielding;

import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.init.ParticleInit;
import eva.dualwielding.network.BalancePacket;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingClient implements ClientModInitializer {

    public static final String MOD_ID = DualWieldingMain.MOD_ID + "-client";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    private static boolean iMLoaded = false;

    public static boolean iMLoaded() {return iMLoaded;}

    @Override
    public void onInitializeClient() {

        ParticleInit.initClient();

        LOGGER.info("hai is me eva");
        LOGGER.info("y is u reeding tha log insted of wielding the simps dually");
        LOGGER.info("this was much work");
        LOGGER.info("tha packts wr so hrd");

        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            ClientPlayNetworking.registerGlobalReceiver(ConfigPacket.TYPE, (packet, player, sender) -> {
                SimplyDualWieldingConfig.onConfigReceived(packet);
                LOGGER.info("applied server config");
            });
            ClientPlayNetworking.registerGlobalReceiver(ListPacket.TYPE, (packet, player, sender) -> {
                SimplyDualWieldingConfig.onListReceived(packet);
                LOGGER.info("applied server lists");
            });
            ClientPlayNetworking.registerGlobalReceiver(BalancePacket.TYPE, (packet, player, sender) -> {
                SimplyDualWieldingConfig.onBalanceReceived(packet);
                LOGGER.info("applied server balance");
            });
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("Removing server config");
            client.execute(SimplyDualWieldingConfig::disconnect);
        });
    }
}
