package eva.dualwielding.network;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.function.Function;


public record BalancePacket(double[] values) implements FabricPacket {

    public static final class_2960 ID = new class_2960("sdw", "balance");

    public static final PacketType<BalancePacket> TYPE = PacketType.create(ID, new Function<class_2540, BalancePacket>() {
        @Override
        public BalancePacket apply(class_2540 friendlyByteBuf) {
            return new BalancePacket(new double[]{
                    friendlyByteBuf.readDouble(),
                    friendlyByteBuf.readDouble(),
                    friendlyByteBuf.readDouble()
            });
        }
    });

    public BalancePacket(class_2540 buf) {
        this(
                new double[]{
                        buf.readDouble(),
                        buf.readDouble(),
                        buf.readDouble()
                }
        );
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeDouble(values[0]);
        buf.writeDouble(values[1]);
        buf.writeDouble(values[2]);
    }

    public double[] getValues() {
        return values;
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public static class_2540 buf(double[] values) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(values[0]);
        buf.writeDouble(values[1]);
        buf.writeDouble(values[2]);
        return buf;
    }

    public class_2960 getIdentifier() {return ID;}

}