package eva.dualwielding.network;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import java.util.function.Function;


public record BalancePacket(double[] values) implements FabricPacket {

    public static final class_2960 BALANCE_PACKET_ID = class_2960.method_43902("eva", "balance");

    public static final PacketType<BalancePacket> TYPE = PacketType.create(BALANCE_PACKET_ID, new Function<class_2540, BalancePacket>() {
        @Override
        public BalancePacket apply(class_2540 friendlyByteBuf) {
            return new BalancePacket(new double[]{
                    friendlyByteBuf.readDouble(),
                    friendlyByteBuf.readDouble(),
                    friendlyByteBuf.readDouble()
            });
        }
    });

    @Override
    public void write(class_2540 buf) {
        buf.method_52940(values[0]);
        buf.method_52940(values[1]);
        buf.method_52940(values[2]);
        buf.method_52940(values[3]);
        buf.method_52940(values[4]);
        buf.method_52940(values[5]);
    }

    public double[] getValues() {
        return values;
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }
}