package eva.dualwielding.mixin;

import com.mojang.serialization.MapCodec;
import eva.dualwielding.access.BlockAccess;
import eva.dualwielding.access.PlayerAccess;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_4970.class)
public abstract class AbstractBlockMixin implements BlockAccess {

    @Unique
    public float dualWielding$calcBlockBreakingDelta(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float f = state.method_26214(world, pos);
        if (f == -1.0F) {
            return 0.0F;
        } else {
            int i = ((PlayerAccess) player).dualWielding$canHarvest(state) ? 30 : 100;
            return ((PlayerAccess) player).dualWielding$getBlockBreakingSpeed(state) / f / i;
        }
    }

    @Mixin(class_4970.class_4971.class)
    public abstract static class AbstractBlockStateMixin extends class_2688<class_2248, class_2680> implements BlockAccess {

        protected AbstractBlockStateMixin(class_2248 owner, Reference2ObjectArrayMap<class_2769<?>, Comparable<?>> propertyMap, MapCodec<class_2680> codec) {
            super(owner, propertyMap, codec);
        }

        @Unique
        private final class_4970.class_4971 abs = (class_4970.class_4971) (Object) this;

        @Unique
        public float dualWielding$calcBlockBreakingDelta(class_1657 player, class_1922 world, class_2338 pos) {
            return ((BlockAccess)abs.method_26204()).dualWielding$calcBlockBreakingDelta(abs.method_26233(), player, world, pos);
        }
    }

}
