/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding.mixin;

import eva.dualwielding.DualWieldingMain;
import eva.dualwielding.access.LivingEntityAccess;
import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.access.ServerPlayerGameModeAccess;
import eva.dualwielding.network.MinePacket;
import eva.dualwielding.util.OffhandMine;
import java.util.Objects;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_5552;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3225.class})
public class ServerPlayerGameModeMixin
implements ServerPlayerGameModeAccess {
    @Final
    @Shadow
    protected class_3222 field_14008;
    @Shadow
    protected class_3218 field_14007;
    @Shadow
    private class_1934 field_14005;
    @Shadow
    private int field_20330;
    @Shadow
    private int field_20326;
    @Shadow
    private boolean field_20328;
    @Shadow
    private class_2338 field_20329;
    @Shadow
    private class_2338 field_20327;
    @Shadow
    private int field_20331;
    @Shadow
    private boolean field_14003;
    @Shadow
    private int field_14000;

    @Unique
    private int useTickCounter() {
        return this.field_14000 + 1;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        ((LivingEntityAccess)this.field_14008).dualWielding$setMainHandStack(true);
        if (this.field_20328) {
            class_2680 blockState = this.field_14007.method_8320(this.field_20329);
            if (blockState.method_26215()) {
                this.field_20328 = false;
            } else {
                float f = this.dualWielding$continueMining(blockState, this.field_20329, this.field_20330);
                if (f >= 1.0f) {
                    this.field_20328 = false;
                    this.dualWielding$tryBreakBlock(this.field_20329);
                }
            }
        } else if (this.field_14003) {
            class_2680 blockState = this.field_14007.method_8320(this.field_20327);
            if (blockState.method_26215()) {
                this.field_14007.method_8517(this.field_14008.method_5628(), this.field_20327, -1);
                this.field_20331 = -1;
                this.field_14003 = false;
            } else {
                this.dualWielding$continueMining(blockState, this.field_20327, this.field_20326);
            }
        }
        ((LivingEntityAccess)this.field_14008).dualWielding$setMainHandStack(false);
    }

    @Override
    @Unique
    public void dualWielding$handleBlockBreakingAction(class_2338 pos, MinePacket.MinePayload.Action action, class_2350 direction, int worldHeight, int sequence) {
        if (!this.field_14008.method_56093(pos, 1.0)) {
            this.dualWielding$method_41250(pos, false, sequence, "too far");
        } else if (pos.method_10264() > worldHeight) {
            this.field_14008.field_13987.method_14364((class_2596)new class_2626(pos, this.field_14007.method_8320(pos)));
            this.dualWielding$method_41250(pos, false, sequence, "too high");
        } else if (action == MinePacket.MinePayload.Action.START_DESTROY_BLOCK) {
            if (!this.field_14007.method_8505((class_1297)this.field_14008, pos)) {
                this.field_14008.field_13987.method_14364((class_2596)new class_2626(pos, this.field_14007.method_8320(pos)));
                this.dualWielding$method_41250(pos, false, sequence, "may not interact");
                return;
            }
            if (!((PlayerAccess)this.field_14008).dualWielding$blockActionRestricted((class_1937)this.field_14007, pos, this.field_14005)) {
                this.field_14008.field_13987.method_14364((class_2596)new class_2626(pos, this.field_14007.method_8320(pos)));
                this.dualWielding$method_41250(pos, false, sequence, "block action restricted");
                return;
            }
            this.field_20326 = this.useTickCounter();
            float f = 1.0f;
            class_2680 blockState = this.field_14007.method_8320(pos);
            if (!blockState.method_26215()) {
                class_1890.method_60124((class_3218)this.field_14007, (class_1799)this.field_14008.method_6079(), (class_1309)this.field_14008, (class_1297)this.field_14008, (class_1304)class_1304.field_6173, (class_243)class_243.method_24953((class_2382)pos), (class_2680)blockState, item -> this.field_14008.method_20235(item, class_1304.field_6171));
                blockState.method_26179((class_1937)this.field_14007, pos, (class_1657)this.field_14008);
                f = OffhandMine.getDestroyProgress(blockState, (class_1657)this.field_14008, (class_1922)this.field_14008.method_51469(), pos);
            }
            if (!blockState.method_26215() && f >= 1.0f) {
                this.dualWielding$finishMining(pos, sequence, "insta mine");
            } else {
                if (this.field_14003) {
                    this.field_14008.field_13987.method_14364((class_2596)new class_2626(this.field_20327, this.field_14007.method_8320(this.field_20327)));
                    this.dualWielding$method_41250(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.field_14003 = true;
                this.field_20327 = pos.method_10062();
                int i = (int)(f * 10.0f);
                this.field_14007.method_8517(this.field_14008.method_5628(), pos, i);
                this.dualWielding$method_41250(pos, true, sequence, "actual start of destroying");
                this.field_20331 = i;
            }
        } else if (action == MinePacket.MinePayload.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.field_20327)) {
                int j = this.useTickCounter() - this.field_20326;
                class_2680 blockStatex = this.field_14007.method_8320(pos);
                if (!blockStatex.method_26215()) {
                    float g = OffhandMine.getDestroyProgress(blockStatex, (class_1657)this.field_14008, (class_1922)this.field_14008.method_51469(), pos) * (float)(j + 1);
                    if (g >= 0.7f) {
                        this.field_14003 = false;
                        this.field_14007.method_8517(this.field_14008.method_5628(), pos, -1);
                        this.dualWielding$finishMining(pos, sequence, "destroyed");
                        return;
                    }
                    if (!this.field_20328) {
                        this.field_14003 = false;
                        this.field_20328 = true;
                        this.field_20329 = pos;
                        this.field_20330 = this.field_20326;
                    }
                }
            }
            this.dualWielding$method_41250(pos, true, sequence, "stopped destroying");
        } else if (action == MinePacket.MinePayload.Action.ABORT_DESTROY_BLOCK) {
            this.field_14003 = false;
            if (!Objects.equals(this.field_20327, pos)) {
                DualWieldingMain.LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.field_20327, (Object)pos);
                this.field_14007.method_8517(this.field_14008.method_5628(), this.field_20327, -1);
                this.dualWielding$method_41250(pos, true, sequence, "aborted mismatched destroying");
            }
            this.field_14007.method_8517(this.field_14008.method_5628(), pos, -1);
            this.dualWielding$method_41250(pos, true, sequence, "aborted destroying");
        }
    }

    @Override
    @Unique
    public float dualWielding$continueMining(class_2680 state, class_2338 pos, int failedStartMiningTime) {
        int i = this.useTickCounter() - failedStartMiningTime;
        float f = OffhandMine.getDestroyProgress(state, (class_1657)this.field_14008, (class_1922)this.field_14008.method_51469(), pos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.field_20331) {
            this.field_14007.method_8517(this.field_14008.method_5628(), pos, j);
            this.field_20331 = j;
        }
        return f;
    }

    @Override
    @Unique
    public void dualWielding$finishMining(class_2338 pos, int sequence, String reason) {
        if (this.dualWielding$tryBreakBlock(pos)) {
            this.dualWielding$method_41250(pos, true, sequence, reason);
        } else {
            this.field_14008.field_13987.method_14364((class_2596)new class_2626(pos, this.field_14007.method_8320(pos)));
            this.dualWielding$method_41250(pos, false, sequence, reason);
        }
    }

    @Override
    @Unique
    public boolean dualWielding$tryBreakBlock(class_2338 pos) {
        class_2680 blockState = this.field_14007.method_8320(pos);
        if (!this.field_14008.method_6079().method_66334(blockState, (class_1937)this.field_14007, pos, (class_1657)this.field_14008)) {
            return false;
        }
        class_2586 blockEntity = this.field_14007.method_8321(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_5552 && !this.field_14008.method_7338()) {
            this.field_14007.method_8413(pos, blockState, blockState, 3);
            return false;
        }
        if (this.field_14008.method_21701((class_1937)this.field_14007, pos, this.field_14005)) {
            return false;
        }
        class_2680 blockState2 = block.method_9576((class_1937)this.field_14007, pos, blockState, (class_1657)this.field_14008);
        if (!((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak((class_1937)this.field_14007, (class_1657)this.field_14008, pos, blockState2, blockEntity)) {
            return false;
        }
        boolean bl = this.field_14007.method_8650(pos, false);
        if (bl) {
            block.method_9585((class_1936)this.field_14007, pos, blockState2);
        }
        if (!this.field_14008.method_66324()) {
            class_1799 itemStack = this.field_14008.method_6079();
            class_1799 itemStack2 = itemStack.method_7972();
            boolean bl2 = ((PlayerAccess)this.field_14008).dualWielding$canHarvest(blockState2);
            itemStack.method_7952((class_1937)this.field_14007, blockState2, pos, (class_1657)this.field_14008);
            if (bl && bl2) {
                block.method_9556((class_1937)this.field_14007, (class_1657)this.field_14008, pos, blockState2, blockEntity, itemStack2);
            }
        }
        return true;
    }

    @Shadow(prefix="dualWielding$")
    private void dualWielding$method_41250(class_2338 pos, boolean success, int sequence, String reason) {
    }
}

