package eva.dualwielding;

import eva.dualwielding.access.PlayerAccess;
import eva.dualwielding.init.ParticleInit;
import eva.dualwielding.network.AttackPayload;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingMain implements ModInitializer {

    public static final String MOD_ID = "dual-wielding";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_2960 ATTACK_PACKET_ID = class_2960.method_60655("eva", "off_attack");

    @Override
    public void onInitialize() {
        ParticleInit.initServer();
        PayloadTypeRegistry.playC2S().register(AttackPayload.ID, AttackPayload.CODEC);
        if (!ServerPlayNetworking.registerGlobalReceiver(AttackPayload.ID, (payload, context) -> {

            class_1297 entityId = context.player().method_37908().method_8469(payload.entityId());
            context.server().execute(() -> {
                class_3222 tp = context.player();
                tp.method_14234();
                assert entityId != null;
                if (context.player().method_37908().method_8469(entityId.method_5628()) != null) {
                    ((PlayerAccess) tp).attackOffhand(tp.method_37908().method_8469(entityId.method_5628()));
                }
            });
        })) {
            LOGGER.error("ugh dammit nooo");
        }
    }
}