/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding.config;

import eva.dualwielding.config.ConditionalBehavior;
import eva.dualwielding.config.ItemCat;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SimplyDualWieldingConfig {
    private boolean empty = false;
    private ItemCat attacks = ItemCat.ALL;
    private ItemCat mines = ItemCat.ALL;
    private List<String> attackList;
    private List<String> mineList;
    private List<String> disableUseList;
    private boolean[] allowWeakConfig = new boolean[]{false, false, false, false};
    private boolean respectIMMining = true;
    private boolean respectIMAttacking = true;
    private ConditionalBehavior restrictUse = ConditionalBehavior.SNEAKING_ONLY;
    private static SimplyDualWieldingConfig INSTANCE;
    private static SimplyDualWieldingConfig SERVER_INSTANCE;
    private static final List<String> def;
    private static final List<String> defUseList;
    private static ListState listState;

    private SimplyDualWieldingConfig() {
        this.attackList = def;
        this.mineList = def;
        this.disableUseList = defUseList;
    }

    public SimplyDualWieldingConfig(boolean empty, ItemCat attacks, ItemCat mines, ConditionalBehavior restrictUse, boolean[] allowWeakConfig) {
        this.empty = empty;
        this.attacks = attacks;
        this.mines = mines;
        this.restrictUse = restrictUse;
        this.allowWeakConfig = allowWeakConfig;
        this.attackList = def;
        this.mineList = def;
        this.disableUseList = defUseList;
    }

    public static SimplyDualWieldingConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimplyDualWieldingConfig();
        }
        return INSTANCE;
    }

    public static SimplyDualWieldingConfig getServerInstance() {
        return SERVER_INSTANCE;
    }

    private static void setServerInstance(SimplyDualWieldingConfig newInstance) {
        SERVER_INSTANCE = newInstance;
    }

    public void updateConfigs(SimplyDualWieldingConfig config) {
        this.empty = config.empty;
        this.attacks = config.attacks;
        this.mines = config.mines;
        this.restrictUse = config.restrictUse;
        SimplyDualWieldingConfig.setAttackItems(config.attackList);
        SimplyDualWieldingConfig.setMineItems(config.mineList);
        SimplyDualWieldingConfig.setDisableUseItems(config.disableUseList);
        this.allowWeakConfig = config.allowWeakConfig;
        this.respectIMMining = config.respectIMMining;
        this.respectIMAttacking = config.respectIMAttacking;
    }

    static void setEmpty(boolean setter) {
        SimplyDualWieldingConfig.getInstance().empty = setter;
    }

    public boolean getEmpty() {
        return this.empty;
    }

    static void setRestrictUse(ConditionalBehavior setter) {
        SimplyDualWieldingConfig.getInstance().restrictUse = setter;
    }

    public ConditionalBehavior getRestrictUse() {
        return this.restrictUse;
    }

    static void setAttacks(ItemCat setter) {
        SimplyDualWieldingConfig.getInstance().attacks = setter;
    }

    public ItemCat getAttacks() {
        return this.attacks;
    }

    static void setMines(ItemCat setter) {
        SimplyDualWieldingConfig.getInstance().mines = setter;
    }

    public ItemCat getMines() {
        return this.mines;
    }

    public List<String> getAttackItems() {
        return this.attackList;
    }

    static void setAttackItems(List<String> newList) {
        SimplyDualWieldingConfig.getInstance().attackList = newList;
    }

    public List<String> getMineItems() {
        return this.mineList;
    }

    static void setMineItems(List<String> newList) {
        SimplyDualWieldingConfig.getInstance().mineList = newList;
    }

    public List<String> getDisableUseItems() {
        return this.disableUseList;
    }

    static void setDisableUseItems(List<String> newList) {
        SimplyDualWieldingConfig.getInstance().disableUseList = newList;
    }

    public boolean getRespectIMAttacking() {
        return this.respectIMAttacking;
    }

    static void setRespectIMAttacking(boolean newVal) {
        SimplyDualWieldingConfig.getInstance().respectIMAttacking = newVal;
    }

    public boolean getRespectIMMining() {
        return this.respectIMMining;
    }

    static void setRespectIMMining(boolean newVal) {
        SimplyDualWieldingConfig.getInstance().respectIMMining = newVal;
    }

    public static Set<class_2960> getSetFromList(List<String> list) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        for (String nam : list) {
            set.add(class_2960.method_60654((String)nam));
        }
        return set;
    }

    public static void onConfigReceived(ConfigPacket payload) {
        SimplyDualWieldingConfig.setServerInstance(payload.getHeldInstance());
    }

    public static void onListReceived(ListPacket listPacket) {
        List<String> list = listPacket.getList();
        for (String entry : list) {
            switch (listState.ordinal()) {
                case 0: {
                    if (entry.isEmpty()) {
                        listState = ListState.MINE;
                        break;
                    }
                    SimplyDualWieldingConfig.SERVER_INSTANCE.attackList.add(entry);
                    break;
                }
                case 1: {
                    if (entry.isEmpty()) {
                        listState = ListState.USE_DISABLED;
                        break;
                    }
                    SimplyDualWieldingConfig.SERVER_INSTANCE.mineList.add(entry);
                    break;
                }
                case 2: {
                    if (entry.isEmpty()) {
                        listState = ListState.ATTACK;
                        break;
                    }
                    if (entry.equals("def")) {
                        SimplyDualWieldingConfig.SERVER_INSTANCE.disableUseList.addAll(defUseList);
                        break;
                    }
                    SimplyDualWieldingConfig.SERVER_INSTANCE.disableUseList.add(entry);
                }
            }
        }
    }

    static Function<String, Optional<class_2561>> getErrorSupplier() {
        return new ErrorSupplier();
    }

    static List<String> getDef() {
        return def;
    }

    public static List<String> getDefUseList() {
        return defUseList;
    }

    public boolean[] getAllowWeakConfig() {
        return this.allowWeakConfig;
    }

    public boolean getAllowWeakConfig(int i) {
        return this.allowWeakConfig[i];
    }

    public static void disconnect() {
        if (SERVER_INSTANCE != null) {
            SERVER_INSTANCE = null;
        }
    }

    static {
        def = new ArrayList<String>();
        def.add("minecraft:air");
        defUseList = new ArrayList<String>();
        defUseList.add("minecraft:wooden_axe");
        defUseList.add("minecraft:stone_axe");
        defUseList.add("minecraft:iron_axe");
        defUseList.add("minecraft:golden_axe");
        defUseList.add("minecraft:diamond_axe");
        defUseList.add("minecraft:netherite_axe");
        defUseList.add("minecraft:wooden_shovel");
        defUseList.add("minecraft:stone_shovel");
        defUseList.add("minecraft:iron_shovel");
        defUseList.add("minecraft:golden_shovel");
        defUseList.add("minecraft:diamond_shovel");
        defUseList.add("minecraft:netherite_shovel");
        defUseList.add("minecraft:wooden_hoe");
        defUseList.add("minecraft:stone_hoe");
        defUseList.add("minecraft:iron_hoe");
        defUseList.add("minecraft:golden_hoe");
        defUseList.add("minecraft:diamond_hoe");
        defUseList.add("minecraft:netherite_hoe");
        listState = ListState.ATTACK;
    }

    private static enum ListState {
        ATTACK,
        MINE,
        USE_DISABLED;

    }

    private static class ErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private ErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(58) != entry.lastIndexOf(58)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 1"));
            }
            String name = entry.substring(entry.indexOf(58) + 1).replaceAll("[^a-z0-9/._-]", "");
            if (!entry.equals(name)) {
                if (entry.indexOf(58) == -1) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 2"));
                }
                String namespace = entry.substring(0, entry.indexOf(58)).replaceAll("[^a-z0-9/._-]", "");
                if (!entry.equals(namespace + ":" + name)) {
                    return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 3"));
                }
            }
            class_2960 id = class_2960.method_60654((String)entry);
            if (!class_7923.field_41178.method_10235().contains(id)) {
                return Optional.of(class_2561.method_43470((String)"Enter a valid item TYPE! error code: 4"));
            }
            return Optional.empty();
        }
    }
}

