package eva.dualwielding;

import eva.dualwielding.config.ConditionalBehavior;
import eva.dualwielding.config.ItemCat;
import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DualWieldingServer implements DedicatedServerModInitializer {

    private static SimplyDualWieldingConfig SERVER_INSTANCE;

    public static final class_2960 CONFIG_PACKET_ID = class_2960.method_43902("eva", "dual_config");

    public static final class_2960 LIST_PACKET_ID = class_2960.method_43902("eva", "config_list");

    public static final String MOD_ID = DualWieldingMain.MOD_ID + "-server";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    @Override
    public void onInitializeServer() {

        SERVER_INSTANCE = SimplyDualWieldingConfig.getInstance();

        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend(handler, ConfigPacket.ID)) {
                LOGGER.info("sending config");
                handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new ConfigPacket(SERVER_INSTANCE)));

                LOGGER.info("config sent");
            } else {
//              You can opt to disconnect the client if it cannot handle the configuration task
                handler.method_52396(class_2561.method_43470("Network configuration not supported by client"));
            }
        });
        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend(handler, ListPacket.ID)) {
                LOGGER.info("sending lists");
                List<String> list = new ArrayList<>();
                List<ItemCat> condition = new ArrayList<>(List.of(new ItemCat[]{ItemCat.WHITELIST, ItemCat.BLACKLIST}));
                if (condition.contains(SERVER_INSTANCE.getAttacks()))
                    list.addAll(SERVER_INSTANCE.getAttackItems());
                list.add("");
                if (condition.contains(SERVER_INSTANCE.getMines()))
                    list.addAll(SERVER_INSTANCE.getMineItems());
                list.add("");
                if (SERVER_INSTANCE.getRestrictUse() != ConditionalBehavior.NEVER)
                    if (!SERVER_INSTANCE.getDisableUseItems().equals(SimplyDualWieldingConfig.getDefUseList()))
                        list.addAll(SERVER_INSTANCE.getDisableUseItems());
                    else
                        list.add("def");
                list.add("");
                while (!list.isEmpty()) {
                    List<String> sub = list.subList(0, Math.min(list.size(), 8));
                    handler.method_14364(ServerConfigurationNetworking.createS2CPacket(new ListPacket(sub)));
                    list.removeAll(sub);
                    if (!list.isEmpty() && !Objects.equals(list.getLast(), "")) list.add("");
                }

                LOGGER.info("lists sent");

            }
        });
    }
}
