package eva.dualwielding.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.dualwielding.access.PlayerAccess;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_759;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_759.class)
public class ItemInHandRendererMixin {
    @Shadow private float offHandHeight;
    @Shadow private float mainHandHeight;

    @Shadow @Final @Mutable private class_310 minecraft;

    @Shadow private class_1799 offHandItem;

    @Unique
    private boolean isOffhandAttack;
    @Unique
    class_1799 itemStack2;

    @Inject(method ="tick",
            at = @At(value = "FIELD",
                    target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;offHandItem:Lnet/minecraft/world/item/ItemStack;",
                    opcode = Opcodes.PUTFIELD,
                    shift = At.Shift.BY))
    private void thief(CallbackInfo ci, @Local class_746 cpe){
        this.itemStack2 = cpe.method_6079();
        this.offHandItem = this.itemStack2;
    }

    @ModifyExpressionValue(method = "tick",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/util/Mth;clamp(FFF)F",
                    ordinal = 3))
    public float modifyH(float original) {
        assert minecraft.field_1724 != null;
        float o = ((PlayerAccess) minecraft.field_1724).dualWielding$getAttackStrengthScale(1.0F);
        if (o < 0.1F) {
            this.isOffhandAttack = true;
        }
        if (this.isOffhandAttack) {
            if (o >= 1.0F) {
                this.isOffhandAttack = false;
            }
            float h = this.offHandItem != itemStack2 ? 0.0F : o * o * o;
            return class_3532.method_15363(h - this.offHandHeight, -0.4F, 0.4F);
        }
        return original;
    }

}
