/*
 * Decompiled with CFR 0.152.
 */
package eva.dualwielding;

import eva.dualwielding.config.SimplyDualWieldingConfig;
import eva.dualwielding.config.enums.BalanceMode;
import eva.dualwielding.config.enums.ConditionalBehavior;
import eva.dualwielding.config.enums.ItemCat;
import eva.dualwielding.network.BalancePacket;
import eva.dualwielding.network.ConfigPacket;
import eva.dualwielding.network.ListPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualWieldingServer
implements DedicatedServerModInitializer {
    private static SimplyDualWieldingConfig SERVER_INSTANCE;
    public static final class_2960 CONFIG_PACKET_ID;
    public static final class_2960 LIST_PACKET_ID;
    public static final class_2960 BALANCE_PACKET_ID;
    public static final String MOD_ID = "sdw-server";
    public static final Logger LOGGER;

    public void onInitializeServer() {
        SERVER_INSTANCE = SimplyDualWieldingConfig.getInstance();
        ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ConfigPacket.ID)) {
                LOGGER.info("sending config");
                handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)new ConfigPacket(SERVER_INSTANCE)));
                LOGGER.info("config sent");
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration not supported by client"));
            }
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ListPacket.ID)) {
                LOGGER.info("sending lists");
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<ItemCat> condition = new ArrayList<ItemCat>(List.of(new ItemCat[]{ItemCat.WHITELIST, ItemCat.BLACKLIST}));
                if (condition.contains((Object)SERVER_INSTANCE.getAttacks())) {
                    list.addAll(SERVER_INSTANCE.getAttackItems());
                }
                list.add("");
                if (condition.contains((Object)SERVER_INSTANCE.getMines())) {
                    list.addAll(SERVER_INSTANCE.getMineItems());
                }
                list.add("");
                if (SERVER_INSTANCE.getRestrictUse() != ConditionalBehavior.NEVER) {
                    if (!SERVER_INSTANCE.getDisableUseItems().equals(SimplyDualWieldingConfig.getDefUseList())) {
                        list.addAll(SERVER_INSTANCE.getDisableUseItems());
                    } else {
                        list.add("def");
                    }
                }
                list.add("");
                while (!list.isEmpty()) {
                    List<String> sub = list.subList(0, Math.min(list.size(), 8));
                    handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)new ListPacket(sub)));
                    list.removeAll(sub);
                    if (list.isEmpty() || Objects.equals(list.getLast(), "")) continue;
                    list.add("");
                }
                LOGGER.info("lists sent");
            }
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ListPacket.ID) && SERVER_INSTANCE.getMode() != BalanceMode.PRETTY_MUCH_BALANCED) {
                LOGGER.info("sending balance");
                handler.method_14364(ServerConfigurationNetworking.createS2CPacket((class_8710)new BalancePacket(SERVER_INSTANCE.getValues())));
            }
        });
    }

    static {
        CONFIG_PACKET_ID = class_2960.method_43902((String)"eva", (String)"config");
        LIST_PACKET_ID = class_2960.method_43902((String)"eva", (String)"list");
        BALANCE_PACKET_ID = class_2960.method_43902((String)"eva", (String)"balance");
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

