package eva.dualwielding.config;

import com.bejker.interactionmanager.Interactions;
import eva.dualwielding.DualWieldingClient;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import static eva.dualwielding.DualWieldingClient.iMLoaded;
import static eva.dualwielding.config.SimplyDualWieldingConfig.*;

public class ConfigInterpreter {

    private static final SimplyDualWieldingConfig[] INSTANCE = {getServerInstance(), getInstance()};
    private static Boolean server;
    private static final boolean[] allowWeak = getServerInstance() != null ? getServerInstance().getAllowWeakConfig() : new boolean[]{true, true, true, true};

    public static boolean checkEmpty(class_1799 stack) {
        if (stack.method_7960()) {
            if (!checkServer() || INSTANCE[0].getEmpty() && allowWeak[0])
                return INSTANCE[1].getEmpty();
            return INSTANCE[0].getEmpty();
        }
        return false;
    }

    public static boolean checkAttacker(class_1799 stack) {
        if (stack.method_7960()) return false;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        for (int lim = (checkServer() && !allowWeak[1]) ? 1 : 2; i < lim; i++) {
            comp[i] = switch (INSTANCE[i].getAttacks()) {
                case ALL -> true;
                case TOOLS -> stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS);
                case WEAPONS -> stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case TOOLS_AND_WEAPONS ->
                        stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS) || stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case NONE -> false;
                case BLACKLIST -> !checkList(0, i, stack.method_7909());
                case WHITELIST -> checkList(0, i, stack.method_7909());
                case null -> false;
            };
        }
        if (!checkServer() || comp[0] && allowWeak[1])
            return comp[1];
        return comp[0];
    }

    public static boolean checkMiner(class_1799 stack) {
        if (stack.method_7960()) return false;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        for (int lim = (checkServer() && !allowWeak[2]) ? 1 : 2; i < lim; i++) {
            comp[i] = switch (INSTANCE[i].getMines()) {
                case ALL -> true;
                case TOOLS -> stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS);
                case WEAPONS -> stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case TOOLS_AND_WEAPONS ->
                        stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS) || stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
                case NONE -> false;
                case BLACKLIST -> !checkList(1, i, stack.method_7909());
                case WHITELIST -> checkList(1, i, stack.method_7909());
                case null -> false;
            };
        }
        if (!checkServer() || comp[0] && allowWeak[2])
            return comp[1];
        return comp[0];
    }

    public static boolean checkRA(class_1657 pe, class_1297 target) {
        if (!iMLoaded) return false;
        if (INSTANCE[1].getRespectIMAttacking()) {
            CallbackInfo ci = new CallbackInfo("dummy", true);
            Interactions.onAttackEntity(pe.method_5667(), target, ci);
            return ci.isCancelled();
        }
        return false;
    }

    public static boolean checkRM(class_2248 block) {
        if (!iMLoaded) return false;
        if (INSTANCE[1].getRespectIMMining()) {
            CallbackInfoReturnable<Boolean> cir = new CallbackInfoReturnable<>("dummy", true, false);
            Interactions.restrictBlockBreaking(block, cir);
            return cir.getReturnValueZ();
        }
        return false;
    }

    @Debug
    public static boolean checkUseRestricted(class_1799 stack, boolean sneaking) {
        if (stack.method_7960()) return false;
        int i = 1;
        boolean[] comp = {false, false};
        if (checkServer()) i = 0;
        for (int lim = (checkServer() && INSTANCE[0].getAllowWeakConfig(3)) ? 1 : 2; i < lim; i++) {
            comp[i] = switch (INSTANCE[i].getRestrictUse()) {
                case ALWAYS -> checkList(2, i, stack.method_7909());
                case SNEAKING_ONLY -> sneaking && checkList(2, i, stack.method_7909());
                case NOT_SNEAKING -> !sneaking && checkList(2, i, stack.method_7909());
                case NEVER -> false;
            };
        }
        DualWieldingClient.LOGGER.info("{} {}", comp[0], comp[1]);
        if (!checkServer() || !comp[0] && INSTANCE[0].getAllowWeakConfig(3))
            return comp[1];
        return comp[0];
    }

    private static boolean checkList(int w, int i, class_1792 item) {
        Set<class_2960> set = switch (w) {
            case 0 -> getSetFromList(INSTANCE[i].getAttackItems());
            case 1 -> getSetFromList(INSTANCE[i].getMineItems());
            case 2 -> getSetFromList(INSTANCE[i].getDisableUseItems());
            default -> ConcurrentHashMap.newKeySet();
        };
        return set.contains(class_7923.field_41178.method_10221(item));
    }

    private static boolean checkServer() {
        if (server == null) {
            server = INSTANCE[0] != null;
        }
        return server;
    }

    public static void init() {
        checkEmpty(class_1799.field_8037);
        checkAttacker(class_1799.field_8037);
        checkMiner(class_1799.field_8037);
        checkUseRestricted(class_1799.field_8037, false);
    }
}
