package eva.dualwielding.mixin.client;

import eva.dualwielding.access.PlayerAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_329.class)
public abstract class InGameHudMixin {

    @Shadow
    @Final
    @Mutable
    private final class_310 client;

    @Unique
    private static final class_2960 CROSS_HAIR_TEXTURE = new class_2960("dualwielding", "textures/gui/crosshair_indicator.png");
    @Unique
    private static final class_2960 HOTBAR_INDICATOR_TEXTURE = new class_2960("dualwielding", "textures/gui/crosshair_indicator.png");

    public InGameHudMixin(class_310 client) {
        this.client = client;
    }

    @Inject(method = "renderCrosshair", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getAttackCooldownProgress(F)F", shift = Shift.AFTER))
    private void renderCrosshairMixinTEST(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        assert this.client.field_1724 != null;
        float o = ((PlayerAccess) this.client.field_1724).dualWielding$getOffhandAttackCooldownProgress(1.0F);
        if (o < 1.0F) {
            int u = (int) (o * 17.0F);
            context.method_25290(class_1921::method_62280, CROSS_HAIR_TEXTURE, context.method_51421() / 2 - 8, context.method_51443() / 2 - 7 + 14, 0.0F, 0.0F, u, 4, 16, 16);
        }
    }

    @Inject(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getAttackCooldownProgress(F)F", shift = Shift.AFTER))
    private void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        assert this.client.field_1724 != null;
        float o = ((PlayerAccess) this.client.field_1724).dualWielding$getOffhandAttackCooldownProgress(1.0F);
        if (o < 1.0F) {
            class_1306 arm = this.client.field_1724.method_6068().method_5928();
            int r = (context.method_51421() / 2) + 91 + 6;
            if (arm == class_1306.field_6183) {
                r = (context.method_51421() / 2) - 91 - 22;
            }
            int s = (int) (o * 19.0F);
            context.method_25290(class_1921::method_62277, HOTBAR_INDICATOR_TEXTURE, r, context.method_51421() - 20 + 18 - s, 0.0F, 18.0F - s, 18, s, 32, 32);
        }
    }

}
